package org.unitedfront2.web.controller.community;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.web.WebUtils;

/**
 * QR~jeBꗗʂ̃Rg[NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.indexAction")
public class IndexAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        User u = WebUtils.findUser(context);
        List<Community> communities = communityTable.findMyCommunities(
                u.getId());
        for (Community c : communities) {
            c.retrieveLastUpdateDate();
        }
        Collections.sort(communities, new Comparator<Community>() {
            @Override
            public int compare(Community c1, Community c2) {
                return c2.getLastUpdateDate().compareTo(c1.getLastUpdateDate());
            }
        });
        context.getRequestScope().put("communities", communities);
        context.getRequestScope().put("_feedUrl", "/community/index.xml");
        return success();
    }
}
