package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.CannotDeleteCommunityException;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.web.flow.BadRequestException;

/**
 * R~jeB폜ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.deleteAction")
public class DeleteAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context)
        throws BadRequestException {
        Community c = Utils.findCommunityAndWriteAccess(context, this,
                communityTable, "code");
        try {
            c.delete();
        } catch (CannotDeleteCommunityException e) {
            logger.warn(e.getMessage(), e);
            throw new BadRequestException(context, this, e);
        }
        return success();
    }
}
