package org.unitedfront2.web.controller.blog;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogTable;

/**
 * JuÖꗗ\ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.publicBlogsAction")
public class PublicBlogsAction extends AbstractAction {

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    @Override
    protected Event doExecute(RequestContext context) {
        List<Blog> blogList = blogTable.findPublicBlogs();
        context.getRequestScope().put("blogs", blogList);
        return success();
    }
}
