package org.unitedfront2.web.controller.blog;

import javax.annotation.Resource;

import org.springframework.stereotype.Repository;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogCodeUsedByOtherException;
import org.unitedfront2.web.controller.SubflowUtils;

/**
 * uO쐬/ҏWp̃ANVNXłBR[hȊO͕ҏWł܂B
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.formAction")
public class FormAction extends
    org.unitedfront2.web.controller.FormAction {

    /** t[XR[vɐݒ肷uOIuWFNg̕ϐ (blog) */
    public static final String BLOG_PARAM_NAME = "blog";

    /** ʑJڂ̍Ō̉ʂ̃{^̃bZ[WR[h̕ϐ (lastSubmitCode) */
    public static final String LAST_SUBMIT_CODE_PARAM_NAME = "lastSubmitCode";

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(Blog.class);
    }

    @Override
    protected void initBinder(RequestContext context, DataBinder binder) {
        super.initBinder(context, binder);
        binder.setAllowedFields(new String[] {"code"});
    }

    /**
     * s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    @Override
    public Event init(RequestContext context) {
        super.init(context);
        context.getFlowScope().put("formReadAccessControlDescription",
                "blog.FormAction.formReadAccessControl.description");
        context.getFlowScope().put("formCommentAccessControlDescription",
            "blog.FormAction.formCommentAccessControl.description");
        context.getFlowScope().put("formMessageDescription",
            "blog.FormAction.formMessage.description");
        context.getFlowScope().put(org.unitedfront2.web.controller.message
                .FormAction.SUBJECT_REQUIRED_PARAM_NAME, true);
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
            "toNext");
        return success();
    }

    @Override
    public Event setupForm(RequestContext context) throws Exception {
        Event event =  super.setupForm(context);
        SubflowUtils.setupMessages(context);
        return event;
    }

    /**
     * uOۑ܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws BlogCodeUsedByOtherException uÕR[hɎgpĂ
     */
    public Event store(RequestContext context)
        throws BlogCodeUsedByOtherException {
        Blog blog = (Blog) context.getFlowScope().get(BLOG_PARAM_NAME);
        try {
            blog.store();
        } catch (BlogCodeUsedByOtherException e) {
            logger.warn(e.getMessage());
            Errors errors = getBindingErrors(context, blog);
            errors.rejectValue("code", "blog.BlogCodeUsedByOtherException");
            throw e;
        }
        return success();
    }

    @Override
    @Resource(name = "blog.formValidator")
    public void setValidator(Validator validator) {
        super.setValidator(validator);
    }
}
