package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.controller.message.FormAction;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * uOL쐬ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.entryCreateAction")
public class EntryCreateAction extends MultiAction {

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    /** hCt@Ng */
    @Autowired private DomainFactory domainFactory;

    public Event init(RequestContext context) {
        context.getFlowScope().put("blogCode",
                context.getRequestParameters().getRequired("blogCode"));
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "blog.EntryCreateForm");
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doPost");
        context.getFlowScope().put(FormAction.SUBJECT_REQUIRED_PARAM_NAME,
                true);
        return success();
    }

    /**
     * uOL𓊍e܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException w肵uOȂ
     */
    public Event post(RequestContext context) throws PageNotFoundException {
        // uO
        Blog blog = Utils.findAndWriteAccessByCode(context, this, blogTable,
                "blogCode");

        // uOL̍\
        SimpleUser user = WebUtils.getUser(context);
        Message entry = (Message) context.getFlowScope().get(
                FormAction.MESSAGE_PARAM_NAME);
        entry.setOwnerId(user.getId());
        entry.setAuthorId(user.getId());
        entry.setReadAccessControl(blog.getReadAccessControl());
        entry.setWriteAccessControl(blog.getWriteAccessControl());

        // e
        BlogEntry blogEntry = domainFactory.prototype(new BlogEntry(entry));
        blog.post(blogEntry);

        return success();
    }
}
