package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogEntryTable;
import org.unitedfront2.domain.communication.Comment;
import org.unitedfront2.web.flow.AccessDeniedException;
import org.unitedfront2.web.flow.BadRequestException;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * Rg폜@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.commentDeleteAction")
public class CommentDeleteAction extends AbstractAction {

    /** uOLe[u */
    @Autowired private BlogEntryTable blogEntryTable;

    /**
     * Rg폜܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException uOL݂Ȃ
     * @throws AccessDeniedException uOLɑ΂ҏWȂ
     * @throws BadRequestException uOLɑ݂ȂRgNGXgꂽ
     */
    @Override
    protected Event doExecute(RequestContext context)
        throws PageNotFoundException, AccessDeniedException,
        BadRequestException {
        String blogCode = context.getRequestParameters().get("blogCode");
        String entryCode = context.getRequestParameters().get("entryCode");
        int commentId = context.getRequestParameters().getInteger("commentId");

        BlogEntry entry = Utils.findAndWriteAccessByCode(context, this,
                blogEntryTable, "entryCode");
        Comment c = entry.findComment(commentId);
        if (c == null) {
            String message = "The invalid comment ID '" + commentId
                + "' requested.";
            logger.warn(message);
            throw new BadRequestException(context, this, message);
        }
        c.delete();

        context.getFlowScope().put("blogCode", blogCode);
        context.getFlowScope().put("entryCode", entryCode);
        return success();
    }
}
