package org.unitedfront2.web.controller.account;

import javax.annotation.Resource;

import org.springframework.stereotype.Repository;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.web.controller.FormAction;

/**
 * pX[hύX̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "account.mailAddrRegisterAction")
public class MailAddrRegisterAction extends FormAction {

    /** AJEgIuWFNg̕ϐ (account) */
    public static final String ACCOUNT_PARAM_NAME = "account";

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(Account.class);
    }

    /**
     * tH[IuWFNgt[XR[vɐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event putFormObject(RequestContext context) {
        context.getFlowScope().put(ACCOUNT_PARAM_NAME, getFormObject(context));
        return success();
    }

    @Override
    @Resource(name = "account.mailAddrFormValidator")
    public void setValidator(Validator validator) {
        super.setValidator(validator);
    }
}
