package org.unitedfront2.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.Errors;

/**
 * Spring̓͒l؂x钊ۃNXłB
 *
 * @author kurokkie
 *
 * @param <V> IWǐ؃NX
 * @param <D> ؑΏۂ̃hCNX
 */
public abstract class SpringValidatorSupport<V, D>
    implements SpringValidator<V> {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** IWǐ؃NX */
    private V originalValidator;

    /**
     * K true ԂĂ܂BKvɉăTuNXŃI[o[ChĂB
     *
     * @param clazz ؑΏۂ̃NX
     * @return ؑΏۂ̃NXȂ true AłȂ false
     * @see org.springframework.validation.Validator#supports(Class)
     */
    @Override
    public boolean supports(Class clazz) {
        return true;
    }

    /**
     * {@link #doValidate(Object, Errors)} ɏϏĂ܂B
     *
     * @param target ؑΏۂ̃IuWFNg
     * @param errors G[
     * @see org.springframework.validation.Validator#validate(Object, Errors)
     */
    @Override
    public final void validate(Object target, Errors errors) {
        doValidate((D) target, errors);
    }

    /**
     * hC^ł邱ƈȊO {@link #validate(Object, Errors)} Ɠl̓
     * ܂B
     *
     * @param domain hCIuWFNg
     * @param errors G[
     */
    protected abstract void doValidate(D domain, Errors errors);

    /**
     * ؗOA<code>errors</code> ɃG[ݒ肵܂B
     *
     * @param field ͖
     * @param e ؗO
     * @param errors G[
     */
    protected void rejectValue(String field, ValidationException e,
            Errors errors) {
        errors.rejectValue(field, e.getCode(), e.getArguments(),
            e.getMessage());
    }

    /**
     * IWǐ؃NX擾܂B
     * @return IWǐ؃NX
     */
    public V getOriginalValidator() {
        return originalValidator;
    }

    /**
     * IWǐ؃NXݒ肵܂B
     * @param originalValidator IWǐ؃NX
     */
    public void setOriginalValidator(V originalValidator) {
        this.originalValidator = originalValidator;
    }

}
