package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.unitedfront2.domain.accesscontrol.AccessControl;

/**
 * Xbh^̃R~jeBłB
 *
 * @invariant ${this.threads[<i>k</i>].ownerId} equals ${this.ownerId}
 * @invariant ${this.threads[<i>k</i>].readAccessControl} equals
 * ${this.readAccessControl}
 * @invariant ${this.threads[<i>k</i>].writeAccessControl} equals
 * ${this.writeAccessControl}
 * @invariant ${this.threads[<i>k</i>].postAccessControl} equals
 * ${this.postAccessControl}
 *
 * @author kurokkie
 *
 */
public class MultiThreadCommunity extends AbstractCommunity
    implements Serializable {

    /** VAԍ */
    private static final long serialVersionUID = -5904029361837475679L;

    /** XbhXg */
    private transient List<Thread> threads;

    public MultiThreadCommunity() {
        super();
    }

    public MultiThreadCommunity(Integer id, String code, Message overview,
            Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl, AccessControl postAccessControl) {
        super(id, code, overview, ownerId, readAccessControl,
                writeAccessControl, postAccessControl);
    }

    public MultiThreadCommunity(String code, Message overview,
            Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl, AccessControl postAccessControl) {
        super(code, overview, ownerId, readAccessControl, writeAccessControl,
                postAccessControl);
    }

    /** XbhȂ΍폜łB */
    @Override
    public boolean isDeletable() {
        retrieveThreads();
        return this.threads.isEmpty();
    }

    @Override
    public <C extends Community> boolean canChangeTo(Class<C> clazz) {
        if (clazz == SingleThreadCommunity.class) {
            if (getId() == null) {
                return true;
            } else {
                retrieveThreads();
                return this.threads.size() <= 1;
            }
        }
        if (clazz == MultiThreadCommunity.class) {
            return true;
        } else {
            String message = "The community type '" + clazz.getClass().getName()
                 + "' not supported.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    protected <C extends Community> C doChangeTo(Class<C> clazz) {
        if (clazz == SingleThreadCommunity.class) {
            return (C) getDomainFactory().prototype(new SingleThreadCommunity(
                    getId(), getCode(), getOverview(), getOwnerId(),
                    getReadAccessControl(), getWriteAccessControl(),
                    getPostAccessControl()));
        }
        if (clazz == MultiThreadCommunity.class) {
            return (C) this;
        } else {
            String message = "The community type '" + clazz.getClass().getName()
                 + "' not supported.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
    }

    /**
     * ŐV̍XVXbh̍XVԂ܂BXbhȂ΃R~jeB̓o^Ԃ
     * B
     */
    @Override
    public void retrieveLastUpdateDate() {
        retrieveThreads();
        if (this.threads.isEmpty()) {
            setLastUpdateDate(getOverview().getRegistrationDate());
            return;
        }
        Thread.retrieveLastUpdateDate(threads);
        for (Thread t : this.threads) {
            t.retrieveEntries(0, 1);
        }
        Thread t = Collections.max(this.threads, new Comparator<Thread>() {
            @Override
            public int compare(Thread t1, Thread t2) {
                return t1.getLastUpdateDate().compareTo(t2.getLastUpdateDate());
            }
        });
        setLastUpdateDate(t.getLastUpdateDate());
    }

    /**
     * XbhVKɓo^܂BXbh̍폜́A{@link Thread#delete()} ō폜ĂB
     *
     * @param thread Xbh
     */
    public void registerThread(Thread thread) {
        thread.store();
        getCommunityDao().registerThread(getId(), thread.getId());
    }

    /** XbhXg𕜌܂Bɕς݂̏ꍇ͉܂B */
    public void retrieveThreads() {
        if (this.threads == null && getId() != null) {
            this.threads = getCommunityDao().findThreads(getId());
        }
    }

    public List<Thread> getThreads() {
        return threads;
    }
}
