package org.unitedfront2.domain.communication;

import org.unitedfront2.dao.MessageDao;
import org.unitedfront2.domain.SimpleTableModule;

/**
 * bZ[We[uW[łB
 *
 * @author kurokkie
 *
 */
public class MessageTable extends SimpleTableModule<Message> {

    /** bZ[Wf[^ANZXIuWFNg */
    private MessageDao messageDao;

    @Override
    protected MessageDao getSimpleDao() {
        return messageDao;
    }

    /**
     * w肵R[hbZ[W擾܂B
     *
     * @param code R[h
     * @return bZ[WAȂꍇ <code>null</code>
     */
    public Message findByCode(String code) {
        return messageDao.findByCode(code);
    }

    /**
     * w肵R[hbZ[W擾܂B
     *
     * @param code R[h
     * @return bZ[W
     * @throws IllegalArgumentException bZ[WȂ
     */
    public Message getByCode(String code) throws IllegalArgumentException {
        Message message = messageDao.findByCode(code);
        if (message == null) {
            String err = "The message code '" + code + "' not found.";
            logger.error(err);
            throw new IllegalArgumentException(err);
        }
        return message;
    }

    /**
     * w肵R[h݂邩肵܂B
     *
     * @param code R[h
     * @return ݂Ȃ <code>true</code> A݂ȂȂ <code>false</code>
     */
    public boolean existByCode(String code) {
        return findByCode(code) != null;
    }

    public void setMessageDao(MessageDao messageDao) {
        this.messageDao = messageDao;
    }
}
