package org.unitedfront2.domain.communication;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.CommunityDao;

/**
 * R~jeB̃e[uW[łB
 *
 * @author kurokkie
 *
 */
public class CommunityTable {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** R~jeBf[^ANZXIuWFNg */
    private CommunityDao communityDao;

    /**
     * R~jeBXgL̓e̍~Ŏ擾܂B
     *
     * @param no Jnԍ
     * @param num 擾R~jeB̍ő吔
     * @return R~jeBXg
     */
    public List<Community> find(int no, int num) {
        return communityDao.findOrderByLastUpdateDateDesc(no, num);
    }

    /**
     * ID ƂēnASȃR~jeBIuWFNg擾܂B
     *
     * @param id ID
     * @return R~jeBAȂꍇ <code>null</code>
     */
    public Community find(int id) {
        return communityDao.find(id);
    }

    /**
     * ID ƂēnASȃR~jeBIuWFNg擾܂B
     *
     * @param id ID
     * @return R~jeB
     * @throws IllegalArgumentException Ή ID R~jeB݂Ȃ
     */
    public Community get(int id) throws IllegalArgumentException {
        Community c = find(id);
        if (c == null) {
            throw new IllegalArgumentException("The community ID '" + id
                    + "' not found.");
        }
        return c;
    }

    /**
     *  ID ƂēnAΉhCIuWFNg݂邩肵܂B
     *
     * @param id ID
     * @return ݂ꍇ <code>true</code>  A݂Ȃꍇ <code>false</code>
     */
    public boolean exist(int id) {
        return find(id) != null;
    }

    /**
     * R[hƂēnASȃR~jeBIuWFNg擾܂B
     *
     * @param code R[h
     * @return R~jeBAȂꍇ <code>null</code>
     */
    public Community findByCode(String code) {
        return communityDao.findByCode(code);
    }

    /**
     * R[hƂēnASȃR~jeBIuWFNg擾܂B
     *
     * @param code R[h
     * @return R~jeB
     * @throws IllegalArgumentException Ή ID R~jeB݂Ȃ
     */
    public Community getByCode(String code) throws IllegalArgumentException {
        Community c = findByCode(code);
        if (c == null) {
            throw new IllegalArgumentException("The community code '" + code
                    + "' not found.");
        }
        return c;
    }

    /**
     *  R[hƂēnAΉhCIuWFNg݂邩肵܂B
     *
     * @param code R[h
     * @return ݂ꍇ <code>true</code>  A݂Ȃꍇ <code>false</code>
     */
    public boolean existByCode(String code) {
        return findByCode(code) != null;
    }

    /**
     * R~jeBXgL̍ŏIXV̍~Ŏ擾܂BԂR~jeBɂ͍ŏIXV
     * 肳ĂԂɂȂ܂B
     *
     * @param no Jnԍ
     * @param num 擾R~jeB̍ő吔
     * @return R~jeBXg
     */
    public List<Community> findOrderByLastUpdateDateDesc(int no, int num) {
        return communityDao.findOrderByLastUpdateDateDesc(no, num);
    }

    /**
     * [UɂJ̑SR~jeB̃Xgo^̍~Ŏ擾܂B
     *
     * @return R~jeBXg
     */
    public List<Community> findPublicCommunities() {
        return communityDao.findPublicCommunities();
    }

    /**
     * [UɂJ̃R~jeBw萔_Ɏ擾܂B
     *
     * @param max ő吔
     * @return R~jeBXg
     */
    public List<Community> findPublicCommunitiesRandomly(int max) {
        return communityDao.findPublicCommunitiesRandomly(max);
    }

    /**
     * Q̃R~jeBXg擾܂B
     *
     * @param userId [U ID
     * @return R~jeBXg
     */
    public List<Community> findMyCommunities(int userId) {
        return communityDao.findMyCommunies(userId);
    }

    public void setCommunityDao(CommunityDao communityDao) {
        this.communityDao = communityDao;
    }
}
