package org.unitedfront2.domain.communication;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * uǑ؃NXłB
 *
 * @author kurokkie
 *
 */
public class BlogValidator implements Serializable {

    /** R[h̐K\̃ftHg ([0-9a-z]+) */
    public static final String DEFAULT_CODE_REGEX = "[0-9a-z]+";

    /** R[hő啶񒷂̃ftHg (32) */
    public static final int DEFAULT_CODE_MAX_LENGTH = 32;

    /** VAԍ */
    private static final long serialVersionUID = -7938436516527392518L;

    /** R[h̐K\ */
    private String codeRegex = DEFAULT_CODE_REGEX;

    /** R[h̍ő啶 */
    private int codeMaxLength = DEFAULT_CODE_MAX_LENGTH;

    /** uOe[u */
    private transient BlogTable blogTable;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof BlogValidator)) {
            return false;
        }
        BlogValidator castOther = (BlogValidator) other;
        return new EqualsBuilder()
            .append(codeRegex, castOther.codeRegex)
            .append(codeMaxLength, castOther.codeMaxLength).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(codeRegex)
            .append(codeMaxLength).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("codeRegex", codeRegex)
            .append("codeMaxLength", codeMaxLength).toString();
    }

    /**
     * R[h؂܂B<p>
     *
     * ؓe
     * <ul>
     *   <li>K{</li>
     *   <li>ő啶</li>
     *   <li>K\</li>
     *   <li></li>
     * </ul>
     *
     * @param blog uO
     * @throws ValidationException {@link ValidationException}
     */
    public void validateCode(Blog blog) throws ValidationException {
        String code = blog.getCode();
        Validate.notBlank(code);
        Validate.maxLength(code, codeMaxLength);
        Validate.match(code, codeRegex);
        Blog found = blogTable.findByCode(code);
        if (found != null && !blog.identify(found)) {
            throw new ValidationException("blog.BlogCodeUsedByOtherException",
                    null, "The code '" + code + "' is used by other.");
        }
    }

    public String getCodeRegex() {
        return codeRegex;
    }

    public void setCodeRegex(String codeRegex) {
        this.codeRegex = codeRegex;
    }

    public int getCodeMaxLength() {
        return codeMaxLength;
    }

    public void setCodeMaxLength(int codeMaxLength) {
        this.codeMaxLength = codeMaxLength;
    }

    public void setBlogTable(BlogTable blogTable) {
        this.blogTable = blogTable;
    }
}
