package org.unitedfront2.domain.communication;

import java.util.List;

import org.unitedfront2.dao.BlogDao;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.EmailForwarding;
import org.unitedfront2.domain.EmailForwardingTable;
import org.unitedfront2.domain.SimpleTableModule;

/**
 * uÕe[uW[łB
 *
 * @author kurokkie
 *
 */
public class BlogTable extends SimpleTableModule<Blog> {

    /** uOf[^ANZXIuWFNg */
    private BlogDao blogDao;

    /** e []ݒe[ug */
    private EmailForwardingTable emailForwardingTable;

    @Override
    protected SimpleFindable<Blog> getSimpleDao() {
        return blogDao;
    }

    /**
     * R[hw肵ăuO擾܂B
     *
     * @param code R[h
     * @return uOAȂ <code>null</code>
     */
    public Blog findByCode(String code) {
        return blogDao.findByCode(code);
    }

    /**
     * R[hw肵ăuO擾܂B
     *
     * @param code R[h
     * @return uO
     * @throws IllegalArgumentException w肵R[h݂Ȃ
     */
    public Blog getByCode(String code) throws IllegalArgumentException {
        Blog blog = findByCode(code);
        if (blog == null) {
            String message = "The blog code '" + code + "' not found.";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        return blog;
    }

    /**
     * R[h݂邩肵܂B
     *
     * @param code R[h
     * @return ݂Ȃ <code>true</code> A݂ȂȂ <code>false</code>
     */
    public boolean existByCode(String code) {
        return findByCode(code) != null;
    }

    /**
     * w肵L҂̃uOXg擾܂B
     *
     * @param ownerId L҂̃[U ID
     * @return uOXg
     */
    public List<Blog> findByOwnerId(int ownerId) {
        return blogDao.findByOwnerId(ownerId);
    }

    /**
     * [UɌJĂuO擾܂BԂl̃Xg͓o^̍~B
     *
     * @return uOXg
     */
    public List<Blog> findPublicBlogs() {
        return blogDao.findPublicBlogs();
    }

    /**
     * [UɌJĂuO擾܂B
     *
     * @param max ő匏
     * @return uOXg
     */
    public List<Blog> findPublicBlogsRandomly(int max) {
        return blogDao.findPublicBlogsRandomly(max);
    }

    /**
     * uORg e-[֓]ݒɂȂĂ邩ǂB
     *
     * @param userId [U ID
     * @return ]sݒɂȂĂꍇ <code>true</code> AȂĂȂȂ
     *     <code>false</code>
     */
    public boolean isBlogCommentForwarding(int userId) {
        return emailForwardingTable.find(userId, EmailForwarding.BLOG_COMMENT);
    }

    public void setBlogDao(BlogDao blogDao) {
        this.blogDao = blogDao;
    }

    public void setEmailForwardingTable(
            EmailForwardingTable emailForwardingTable) {
        this.emailForwardingTable = emailForwardingTable;
    }
}
