package org.unitedfront2.domain;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.unitedfront2.util.PropertyUtils;

/**
 * {@link DomainFactory}  Spring Framework DI ReiłB
 *
 * @author kurokkie
 *
 */
public class SpringBeanDomainFactory implements DomainFactory,
        ApplicationContextAware {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** {@link ApplicationContext} */
    private ApplicationContext applicationContext;

    @Override
    public <D extends Domain> D prototype(Class<D> domainClass) {
        return (D) applicationContext.getBean(toBeanName(domainClass));
    }

    /**
     * ${domainObject} ̔ivpeBhCIuWFNgɃRs[_ɒӂĂ
     * B
     */
    @Override
    public <D extends Domain> D prototype(D domainObject) {
        D o = (D) applicationContext.getBean(toBeanName(domainObject
                .getClass()));
        PropertyUtils.copyProperties(o, domainObject);
        return o;
    }

    private <D extends Domain> String toBeanName(Class<D> domainClass) {
        String name = domainClass.getName();
        name = name.substring(getClass().getPackage().getName().length() + 1);
        StringBuffer sb = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); i++) {
            if (i == 0 || (i > 0 && name.charAt(i - 1) == '.')) {
                sb.append(Character.toLowerCase(name.charAt(i)));
            } else {
                sb.append(name.charAt(i));
            }
        }
        return sb.toString();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
        throws BeansException {
        this.applicationContext = applicationContext;
    }
}
