package org.unitedfront2.web.flow;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.support.ServletContextResource;

public class HierarchyXmlFlowRegistryFactoryBeanTest {

    @Test(expected=IllegalArgumentException.class)
    public void testConventionalFlowIdpX[gWXgŎn܂ĂȂꍇ͗O() {
        ServletContextResource resource = new ServletContextResource(new MockServletContext(), "/flows/dir/sample-flow.xml");
        HierarchyXmlFlowRegistryFactoryBean factoryBean = new HierarchyXmlFlowRegistryFactoryBean();
        factoryBean.conventionalFlowId(resource);
    }

    @Test
    public void testConventionalFlowIdKwꂽt[ID쐬() {
        ServletContextResource resource = new ServletContextResource(new MockServletContext(), "/WEB-INF/flows/dir/sample-flow.xml");
        HierarchyXmlFlowRegistryFactoryBean factoryBean = new HierarchyXmlFlowRegistryFactoryBean();
        String flowId = factoryBean.conventionalFlowId(resource);
        Assert.assertEquals("dir/sample-flow", flowId);
    }

    @Test
    public void testConventionalFlowIdgq̂Ȃt@CKwꂽt[ID쐬() {
        ServletContextResource resource = new ServletContextResource(new MockServletContext(), "/WEB-INF/flows/dir/sample-flow");
        HierarchyXmlFlowRegistryFactoryBean factoryBean = new HierarchyXmlFlowRegistryFactoryBean();
        String flowId = factoryBean.conventionalFlowId(resource);
        Assert.assertEquals("dir/sample-flow", flowId);
    }
}
