package org.unitedfront2.domain.communication;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.SimpleTableModule;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.test.TableModuleTestCaseSupport;

public class BlogTableTest extends TableModuleTestCaseSupport<Blog> {

    @Autowired private BlogTable blogTable;

    @Override
    protected Blog createDomain() {
        AccessControl readAccessControl = domainFactory.prototype(Public.class);
        AccessControl writeAccessControl = domainFactory.prototype(OwnerOnly.class);
        return domainFactory.prototype(new Blog("testblog",
                createOverview(readAccessControl, writeAccessControl),
                simpleUser1.getId(), readAccessControl, writeAccessControl,
                domainFactory.prototype(OwnerOnly.class)));
    }

    private Message createOverview(AccessControl readAccessControl,
            AccessControl writeAccessControl) {
        MessageEntry entry = new MessageEntry();
        entry.setSubject("eXguO");
        entry.setBody("̓eXguOłB");
        Map<Locale, MessageEntry> entryMap = new HashMap<Locale, MessageEntry>();
        entryMap.put(Locale.JAPANESE, entry);
        Message overview = domainFactory.prototype(new Message(null, entryMap,
                simpleUser1.getId(), simpleUser1.getId(),
                readAccessControl, writeAccessControl));
        return overview;
    }

    @Override
    protected SimpleTableModule<Blog> getTableModule() {
        return blogTable;
    }

    @Override
    protected SimpleFindable<Blog> getSimpleDao() {
        return blogTable.getSimpleDao();
    }

    @Test
    public void testPrototypeArgs() {
        Blog blog = createDomain();
        Assert.assertNotNull(blog);
    }
}
