package org.unitedfront2.domain.accesscontrol;

import org.junit.Test;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.Profile;

public class AuthorOnlyTest extends AccessControlTestSupport {

    @Override
    public void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.retrieveSelfIntroduction();
        profile.getSelfIntroduction().setAuthorId(simpleUser3.getId());
        profile.getSelfIntroduction().store();
    }

    @Override
    protected AccessControl getAccessControl() {
        return domainFactory.prototype(AuthorOnly.class);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToResourceɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        accessControl.access(profile);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToCopyrightedResourceɂANZX() throws AccessDeniedException {
        Message message = profileTable.get(simpleUser1.getId()).getSelfIntroduction();
        accessControl.access(message);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToResource҂ɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        accessControl.access(profile, simpleUser3.getId());
    }

    @Test
    public void testAccessToCopyrightedResource҂ɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.retrieveSelfIntroduction();
        accessControl.access(profile.getSelfIntroduction(), simpleUser3.getId());
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToResource҈ȊOɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setCode("_____tester");
        simpleUser.setId(-1);
        simpleUser.setName("_____eX^[");
        User user = domainFactory.prototype(simpleUser);
        accessControl.access(profile, user.getId());
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToCopyrightedResource҈ȊOɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.retrieveSelfIntroduction();
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setCode("_____tester");
        simpleUser.setId(-1);
        simpleUser.setName("_____eX^[");
        User user = domainFactory.prototype(simpleUser);
        accessControl.access(profile.getSelfIntroduction(), user.getId());
    }
}
