package org.unitedfront2.domain.accesscontrol;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageTable;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class AbstractResourceTest extends
        TransactionalTestCaseWithInitialData {

    @Autowired protected SimpleUserTable simpleUserTable;

    @Autowired protected MessageTable messageTable;

    @Autowired protected AccessControlTable accessControlTable;

    private AbstractResource resource;

    @Override
    public void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        Message message = domainFactory.prototype(new Message(null, null,
                simpleUser1.getId(), simpleUser2.getId(),
                domainFactory.prototype(Public.class),
                domainFactory.prototype(Public.class)));
        message.store();
        this.resource = message;
    }

    @Test
    public void testRetrieveOwner() {
        Assert.assertNotNull(resource.getOwnerId());
        Assert.assertTrue(simpleUserTable.exist(resource.getOwnerId()));
        resource.retrieveOwner();
        Assert.assertEquals(simpleUserTable.get(resource.getOwnerId()), resource.getOwner());
    }
}
