package org.unitedfront2.domain;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.unitedfront2.test.TestCase;

public class SpringBeanDomainFactoryTest extends TestCase {

    @Autowired private ApplicationContext applicationContext;

    @Test
    public void testhCvg^CvXR[vł邩() {
        String[] domainNames = applicationContext.getBeanNamesForType(Domain.class);
        for (String name : domainNames) {
            logger.info("Domain '" + name + "'.");
            Domain d1 = (Domain) applicationContext.getBean(name);
            Domain d2 = (Domain) applicationContext.getBean(name);
            Assert.assertEquals(d1, d2);
            Assert.assertNotSame(d1, d2);
        }
    }
}
