package org.unitedfront2.domain;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.Account.Role;
import org.unitedfront2.domain.Account.Status;
import org.unitedfront2.test.TableModuleTestCaseSupport;

public class AccountTableTest extends TableModuleTestCaseSupport<Account> {

    @Autowired private AccountTable accountTable;

    @Override
    protected Account createDomain() {
        Account account = domainFactory.prototype(Account.class);
        account.setMailAddr("account@exmaple.com");
        account.setPlainPassword("password");
        account.addRole(Role.ROLE_USER);
        account.setStatus(Status.AVAILABLE);
        account.encrypt();
        return account;
    }

    @Override
    protected SimpleTableModule<Account> getTableModule() {
        return accountTable;
    }

    @Override
    protected SimpleFindable<Account> getSimpleDao() {
        return accountTable.getSimpleDao();
    }

    @Test
    public void testFindByMailAddr[AhXɃAJEg[h() throws MailAddrUsedByOtherException {
        account1.store();
        Account loadedAccount = accountTable.findByMailAddr(account1.getMailAddr());
        Assert.assertEquals(account1, loadedAccount);
    }

    @Test
    public void testFindByMailAddr݂Ȃ[AhX() throws MailAddrUsedByOtherException {
        Assert.assertNull("AJEg݂Ă", accountTable.findByMailAddr("__"));
    }

    @Test
    public void testExistByMailAddr() throws MailAddrUsedByOtherException {
        account1.store();
        Assert.assertTrue("Ȃ", accountTable.existByMailAddr(account1.getMailAddr()));
    }

    @Test
    public void testExistByMailAddrȂ() {
        Assert.assertFalse("Ă܂", accountTable.existByMailAddr("test@example.com"));
    }
}
