package org.unitedfront2.web.security;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.Authentication;

/**
 * FؐɃ_CNg {@link
 * org.springframework.security.ui.rememberme.RememberMeProcessingFilter} łB
 * ɂāAANZXɃZbV񂪑݂Ȃ󋵂h܂B
 *
 * @author kurokkie
 *
 */
public class RememberMeProcessingRedirectFilter extends
    org.springframework.security.ui.rememberme.RememberMeProcessingFilter {

    @Override
    protected void onSuccessfulAuthentication(HttpServletRequest request,
            HttpServletResponse response, Authentication authResult) {
        getRememberMeServices().loginSuccess(request, response, authResult);
        try {
            response.sendRedirect(request.getRequestURI());
        } catch (IOException e) {
            logger.error(e);
            throw new IllegalStateException(e);
        }
    }
}
