package org.unitedfront2.web.handler;

import java.util.Collections;
import java.util.List;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.support.RequestContextUtils;
import org.unitedfront2.web.WebUtils;

/**
 * NCAg̎gpɉČ؂ւC^[Zv^łB
 *
 * @author kurokkie
 *
 */
public class LocaleChangeInterceptor
    extends org.springframework.web.servlet.i18n.LocaleChangeInterceptor {

    /** p\P[Xg */
    private List<Locale> availableLocales;

    /**
     * NGXgɃP[ƁAp\ȃP[Xgݒ肵܂B
     *
     * @param request HTTP NGXg
     * @param response HTTP X|X
     * @param handler nh
     * @return ȍ~̃C^[Zv^ĂяoȂ true AłȂ false
     * @throws ServletException T[ubgO
     */
    @Override
    public boolean preHandle(HttpServletRequest request,
        HttpServletResponse response, Object handler)
        throws ServletException {

        boolean result = super.preHandle(request, response, handler);
        Locale locale = RequestContextUtils.getLocale(request);
        request.setAttribute(WebUtils.LOCALE_PARAM_NAME, locale);
        request.setAttribute(WebUtils.AVAILABLE_LOCALES_PARAM_NAME,
                availableLocales);
        return result;
    }

    /**
     * p\P[XgAύXȂXgƂĐݒ肵܂B
     * @param availableLocales p\P[Xg
     */
    public void setAvailableLocales(List<Locale> availableLocales) {
        this.availableLocales = Collections.unmodifiableList(availableLocales);
    }
}
