package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.AuthorOnly;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageCodeUsedByOtherException;
import org.unitedfront2.domain.communication.MultiThreadCommunity;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.domain.communication.Thread.Status;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.controller.message.FormAction;

/**
 * R~jeB쐬/ҏWp̃ANVNXłBR[hȊO͕ҏWł܂B
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.threadFormAction")
public class ThreadFormAction extends MultiAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    /** hCt@Ng */
    @Autowired
    private DomainFactory domainFactory;

    /**
     * s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        // t[XR[vɃZbg
        putCommunity(context);
        putThread(context);

        Thread t = (Thread) context.getFlowScope().get("thread");
        if (t == null) {
            // VKo^
            context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                    "community.ThreadCreateForm");
            context.getFlowScope().put(FormAction.SUBJECT_REQUIRED_PARAM_NAME,
                    true);
            context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                    "doCreate");
        } else {
            // XV
            context.getFlowScope().put("overview", t.getOverview());
            context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                    "community.ThreadUpdateForm");
            context.getFlowScope().put(FormAction.SUBJECT_REQUIRED_PARAM_NAME,
                    true);
            context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                    "doUpdate");
        }
        return success();
    }

    private void putCommunity(RequestContext context) {
        Community c = Utils.findCommunityAndPostAccess(context, this,
                communityTable, "communityCode");
        context.getFlowScope().put("community", c);
    }

    private void putThread(RequestContext context) {
        Integer threadId = context.getRequestParameters().getInteger(
                "threadId");
        if (threadId == null) {
            // VK̃Xbh
            context.getFlowScope().put("thread", null);
        } else {
            // ̃Xbh
            Community community = (Community) context.getFlowScope().get(
                    "community");
            Thread t = Utils.findThreadAndWriteAccess(context, this, community,
                    "threadId");
            context.getFlowScope().put("thread", t);
        }
    }

    /**
     * Xbhۑ܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event store(RequestContext context) {
        Community community = (Community) context.getFlowScope().get(
                "community");
        SimpleUser u = WebUtils.findUser(context);
        Thread t = (Thread) context.getFlowScope().get("thread");
        if (t == null) {
            // VKo^
            Message overview = (Message) context.getFlowScope().get("overview",
                    Message.class);

            // Xbh̕ҏW̂͒
            AccessControl wac = domainFactory.prototype(AuthorOnly.class);
            overview.setOwnerId(community.getOwnerId());
            overview.setAuthorId(u.getId());
            overview.setReadAccessControl(community.getReadAccessControl());
            overview.setWriteAccessControl(wac);
            t = domainFactory.prototype(new Thread(overview,
                    Status.AVAILABLE, u.getId(),
                    community.getReadAccessControl(), wac,
                    community.getPostAccessControl()));
            if (community instanceof MultiThreadCommunity) {
                MultiThreadCommunity c = (MultiThreadCommunity) community;
                c.registerThread(t);
            }
            context.getFlowScope().put("thread", t);
        } else {
            // XV
            Message overview = (Message) context.getFlowScope().get("overview",
                    Message.class);
            try {
                overview.store();
            } catch (MessageCodeUsedByOtherException e) {
                // R[h͕ύXΏۂłȂ̂ŋN肦Ȃ
                throw new IllegalStateException(e);
            }
        }
        return success();
    }
}
