package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Message;

/**
 * L𒼐ډ{ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.entryViewAction")
public class EntryViewAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context) {
        Community c = Utils.findCommunity(context, this, communityTable,
                "communityCode");
        Message entry = Utils.findEntryAndReadAccess(context, this, c,
                "threadId", "entryCode");
        entry.retrieveAuthor();
        entry.getAuthor().retrieveProfile();

        context.getRequestScope().put("community", c);
        context.getRequestScope().put("entry", entry);
        return success();
    }
}
