package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.message.FormAction;

/**
 * Lep̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.entryCreateAction")
public class EntryCreateAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context) {
        Community c = Utils.findCommunityAndPostAccess(context, this,
                communityTable, "communityCode");
        Thread t = Utils.findThread(context, this, c, "threadId");

        context.getFlowScope().put("community", c);
        context.getFlowScope().put(
                org.unitedfront2.web.controller.thread.EntryFormAction
                    .THREAD_ID_PARAM_NAME, t.getId());
        context.getFlowScope().put(FormAction.SUBJECT_DISABLED_PARAM_NAME,
                true);
        context.getFlowScope().put("isAnonymous",
                WebUtils.findUser(context) == null);
        return success();
    }
}
