package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;

/**
 * uO쐬@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.createAction")
public class CreateAction extends AbstractAction {

    /** hCt@Ng */
    @Autowired private DomainFactory domainFactory;

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "blog.CreateForm");
        context.getFlowScope().put(FormAction.LAST_SUBMIT_CODE_PARAM_NAME,
                "doCreate");
        User user = WebUtils.getUser(context);
        Blog blog = createBlog(user);
        context.getFlowScope().put(FormAction.BLOG_PARAM_NAME, blog);
        return success();
    }

    private Blog createBlog(User user) {
        AccessControl readAccessControl = domainFactory.prototype(
                UserOnly.class);
        AccessControl writeAccessControl = domainFactory.prototype(
                OwnerOnly.class);
        return domainFactory.prototype(new Blog(null,
                createOverview(user, readAccessControl, writeAccessControl),
                user.getId(), readAccessControl, writeAccessControl,
                domainFactory.prototype(UserOnly.class)));
    }

    private Message createOverview(User user, AccessControl readAccessControl,
            AccessControl writeAccessControl) {
        return domainFactory.prototype(new Message(null, null, user.getId(),
                user.getId(), readAccessControl, writeAccessControl));
    }
}
