package org.unitedfront2.web.controller.account;

import javax.annotation.Resource;

import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.providers
    .UsernamePasswordAuthenticationToken;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.MailAddrAndPassword;
import org.unitedfront2.web.controller.FormAction;

/**
 * F؂sANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "account.authenticationAction")
public class AuthenticationAction extends FormAction {

    /** F؋@\ */
    @Resource(name = "authenticationManager")
    private AuthenticationManager authenticationManager;

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(MailAddrAndPassword.class);
    }

    /**
     * F؂s܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws AuthenticationFailedException F؂Ɏs
     */
    public Event authenticate(RequestContext context)
        throws AuthenticationFailedException {
        MailAddrAndPassword mailAddrAndPassword
            = (MailAddrAndPassword) getFormObject(context);
        if (authenticate(mailAddrAndPassword)) {
            return success();
        } else {
            Errors errors = getBindingErrors(context, mailAddrAndPassword);
            errors.reject("account.AuthenticationAction.error");
            throw new AuthenticationFailedException();
        }
    }

    private boolean authenticate(MailAddrAndPassword mailAddrAndPassword) {

        UsernamePasswordAuthenticationToken auth
            = new UsernamePasswordAuthenticationToken(
                    mailAddrAndPassword.getMailAddr(),
                    mailAddrAndPassword.getPassword());

        try {
            authenticationManager.authenticate(auth);
            return true;
        } catch (AuthenticationException e) {
            logger.warn(e.getMessage());
            return false;
        }
    }
}
