package org.unitedfront2.web.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.Errors;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.Installer;
import org.unitedfront2.domain.MailAddrAndPassword;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.UserCodeUsedByOtherException;
import org.unitedfront2.domain.UserNameUsedByOtherException;
import org.unitedfront2.web.controller.account.MailAddrRegisterAction;

/**
 * [U̐VKo^sANVNXłB
 *
 * @author kurokkie
 *
 */
// CXg[ݒ肷Kv邽߁AapplicationContext-controller.xml t@C Bean `
public class RegistrationAction extends FormAction {

    /** [Uo^ɐۂ̃[ev[g (account.Registration-mail) */
    public static final String SUCCESS_MAIL_TEMPLATE_NAME = "Registration-mail";

    /** [Uo^Ɏsۂ̃[ev[g (account.RegistrationFailure-mail) */
    public static final String FAILURE_MAIL_TEMPLATE_NAME
        = "RegistrationFailure-mail";

    /** spX[h̍ŏ (4) */
    public static final int PASSWORD_MIN_LENGTH = 4;

    /** ftHg̔spX[h̍ő啶 (8) */
    public static final int PASSWORD_MAX_LENGTH = 8;

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    /** CXg[Xg */
    private List<Installer> installers;

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(Account.class);
        setMailTemplateNames(new String[] {
            SUCCESS_MAIL_TEMPLATE_NAME,
            FAILURE_MAIL_TEMPLATE_NAME,
        });
    }

    /**
     * Tut[ɑ΂鏉s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        super.init(context);
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "Registration.user.Form");
        context.getFlowScope().put(
                SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME, "toNext");
        return success();
    }

    /**
     * VKo^s܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws MailAddrUsedByOtherException
     *     [AhXɑ̃[UɂĎgpĂ
     * @throws UserCodeUsedByOtherException
     *     [UR[hɑ̃[UɂĎgpĂ
     * @throws UserNameUsedByOtherException
     *     [Uɑ̃[UɂĎgpĂ
     */
    public Event register(RequestContext context)
        throws MailAddrUsedByOtherException, UserCodeUsedByOtherException,
        UserNameUsedByOtherException {

        Account account = (Account) context.getFlowScope()
            .get(MailAddrRegisterAction.ACCOUNT_PARAM_NAME);
        SimpleUser user = (SimpleUser) context.getFlowScope()
            .get(org.unitedfront2.web.controller.user.FormAction
                    .USER_PARAM_NAME);
        try {
            MailAddrAndPassword mailAddrAndPassword
                = register(account, user);
            context.getRequestScope().put("mailAddrAndPassword",
                    mailAddrAndPassword);
            sendMail(context);
            return success();
        } catch (MailAddrUsedByOtherException e) {
            logger.warn(e.getMessage());
            sendErrorMail(context);
            return success();
        } catch (UserCodeUsedByOtherException e) {
            account.setId(null);
            logger.warn(e.getMessage());
            Errors errors = getBindingErrors(context, user, "simpleUser");
            errors.rejectValue("code",
                "user.UserForm.validation.error.userCodeUsedByOther",
                null, e.getMessage());
            throw e;
        } catch (UserNameUsedByOtherException e) {
            account.setId(null);
            logger.warn(e.getMessage());
            Errors errors = getBindingErrors(context, user, "simpleUser");
            errors.rejectValue("name",
                "user.UserForm.validation.error.userNameUsedByOther",
                new Object[] {e.getUserName()}, e.getMessage());
            throw e;
        }
    }

    private MailAddrAndPassword register(Account account, SimpleUser user)
        throws MailAddrUsedByOtherException, UserCodeUsedByOtherException,
        UserNameUsedByOtherException {

        String plainPassword = Account.createRandomPassword(
                PASSWORD_MIN_LENGTH, PASSWORD_MAX_LENGTH);
        account.setPlainPassword(plainPassword);
        account.addRole(Account.Role.ROLE_USER);
        account.setStatus(Account.Status.AVAILABLE);
        account.encrypt();
        account.store();

        user.setId(account.getId());
        simpleUserTable.install(user);

        if (installers != null) {
            for (Installer installer : installers) {
                installer.install(account.getId());
            }
        }

        return new MailAddrAndPassword(account.getMailAddr(), plainPassword);
    }

    /**
     * [Uo^ɐۂ̃[Ms܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    @Override
    public Event sendMail(RequestContext context) {
        doSendMail(context, SUCCESS_MAIL_TEMPLATE_NAME);
        return success();
    }

    /**
     * [AhXo^ς݂Ƃ̃G[[̑Ms܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event sendErrorMail(RequestContext context) {
        doSendMail(context, FAILURE_MAIL_TEMPLATE_NAME);
        return success();
    }

    public void setInstallers(List<Installer> installers) {
        this.installers = installers;
    }
}
