package org.unitedfront2.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * JavaBean ̃vpeBɊւ鑀x郆[eBeBNXłB{@link
 * org.apache.commons.beanutils.PropertyUtils} ̎gコ[eBeBNX
 * B
 *
 * @author kurokkie
 *
 */
public final class PropertyUtils
    extends org.apache.commons.beanutils.PropertyUtils {

    /** O */
    private static final Log LOGGER = LogFactory.getLog(PropertyUtils.class);

    /**
     * {@link org.apache.commons.beanutils.PropertyUtils#copyProperties(Object,
     * Object)} ̃`FbNO`FbNOɒuĂ܂B
     *
     * @param dest Rs[ JavaBean
     * @param orig Rs[ JavaBean
     * @throws UnsupportedBeanOperationException JavaBean ̑Ɏs
     * @see org.apache.commons.beanutils.PropertyUtils#copyProperties(Object,
     *     Object)
     */
    public static void copyProperties(Object dest, Object orig)
        throws UnsupportedBeanOperationException {

        try {
            org.apache.commons.beanutils.PropertyUtils.copyProperties(dest,
                orig);
        } catch (IllegalAccessException e) {
            String message = "Errors occured while running 'copyProperties' "
                + "method. dest='" + dest + "', orig='" + orig + "'; "
                + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (InvocationTargetException e) {
            String message = "Errors occured while running 'copyProperties' "
                + "method. dest='" + dest + "', orig='" + orig + "'; "
                + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (NoSuchMethodException e) {
            String message = "Errors occured while running 'copyProperties' "
                + "method. dest='" + dest + "', orig='" + orig + "'; "
                + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        }
    }

    /**
     * {@link org.apache.commons.beanutils.PropertyUtils#describe(Object)} 
     * `FbNO`FbNOɒuĂ܂B܂A
     * {@link Object#getClass()} ̉eŎ擾 'class' vpeB͏܂B
     *
     * @param bean JavaBean
     * @return JavaBean  {@link Map} \
     * @throws UnsupportedBeanOperationException JavaBean ̑Ɏs
     * @see org.apache.commons.beanutils.PropertyUtils#describe(Object)
     */
    public static Map<String, Object> describe(Object bean)
        throws UnsupportedBeanOperationException {

        Map<String, Object> beanMap;
        try {
            beanMap = org.apache.commons.beanutils.PropertyUtils.describe(bean);
        } catch (IllegalAccessException e) {
            String message = "Errors occured while running 'describe' method. "
                + "bean='" + bean + "'; " + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (InvocationTargetException e) {
            String message = "Errors occured while running 'describe' method. "
                + "bean='" + bean + "'; " + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (NoSuchMethodException e) {
            String message = "Errors occured while running 'describe' method. "
                + "bean='" + bean + "'; " + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        }
        beanMap.remove("class");
        return beanMap;
    }

    /**
     * {@link org.apache.commons.beanutils.PropertyUtils#getProperty(Object,
     * String)} ̃`FbNO`FbNOɒuĂ܂B
     *
     * @param bean JavaBean
     * @param name vpeB
     * @return vpeBl
     * @throws UnsupportedBeanOperationException JavaBean ̑Ɏs
     * @see org.apache.commons.beanutils.PropertyUtils#getProperty(Object,
     *     String)
     */
    public static Object getProperty(Object bean, String name)
        throws UnsupportedBeanOperationException {

        try {
            return org.apache.commons.beanutils.PropertyUtils.getProperty(bean,
                name);
        } catch (IllegalAccessException e) {
            String message = "Errors occured while running 'getProperty' "
                + "method. bean='" + bean + "' property='" + name + "'; "
                + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (InvocationTargetException e) {
            String message = "Errors occured while running 'getProperty' "
                + "method. bean='" + bean + "' property='" + name + "'; "
                + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (NoSuchMethodException e) {
            String message = "Errors occured while running 'getProperty' "
                + "method. bean='" + bean + "' property='" + name + "'; "
                + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        }
    }

    /**
     * {@link org.apache.commons.beanutils.PropertyUtils#setProperty(Object,
     * String, Object)} ̃`FbNO`FbNOɒuĂ܂B
     *
     * @param bean JavaBean
     * @param name vpeB
     * @param value vpeBl
     * @throws UnsupportedBeanOperationException JavaBean ̑Ɏs
     * @see org.apache.commons.beanutils.PropertyUtils#setProperty(Object,
     *     String, Object)
     */
    public static void setProperty(Object bean, String name, Object value)
        throws UnsupportedBeanOperationException {

        try {
            org.apache.commons.beanutils.PropertyUtils.setProperty(bean, name,
                value);
        } catch (IllegalAccessException e) {
            String message = "Errors occured while running 'setProperty' "
                + "method. bean='" + bean + "' property='" + name
                + "', value='" + value + "'; " + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (InvocationTargetException e) {
            String message = "Errors occured while running 'setProperty' "
                + "method. bean='" + bean + "' property='" + name
                + "', value='" + value + "'; " + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (NoSuchMethodException e) {
            String message = "Errors occured while running 'setProperty' "
                + "method. bean='" + bean + "' property='" + name
                + "', value='" + value + "'; " + e.getMessage();
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        }
    }

    /**
     * w肵vpeB {@link Enum} ^ł邩ǂʂ܂B
     *
     * @param bean JavaBean
     * @param name vpeB
     * @return {@link Enum} ^Ȃ <code>true</code> AłȂ
     *     <code>false</code>
     * @throws UnsupportedBeanOperationException JavaBean ̑Ɏs
     */
    public static boolean isEnum(Object bean, String name)
        throws UnsupportedBeanOperationException {

        return getType(bean, name).isEnum();
    }

    /**
     * w肵vpeB̌^Ԃ܂B
     *
     * @param bean JavaBean
     * @param name vpeB
     * @return vpeB̌^
     * @throws UnsupportedBeanOperationException JavaBean ̑Ɏs
     */
    public static Class getType(Object bean, String name)
        throws UnsupportedBeanOperationException {

        try {
            try {
                return bean.getClass().getMethod(toGetterMethodName(name))
                    .getReturnType();
            } catch (NoSuchMethodException e) {
                return bean.getClass()
                    .getMethod(toBooleanGetterMethodName(name)).getReturnType();
            }
        } catch (SecurityException e) {
            String message = "Errors occured while accessing the getter method "
                + "of the property '" + name + "'";
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        } catch (NoSuchMethodException e) {
            String message = "Errors occured while accessing the getter method "
                + "of the property '" + name + "'";
            LOGGER.debug(message);
            throw new UnsupportedBeanOperationException(message, e);
        }
    }

    private static String toGetterMethodName(String name) {
        StringBuffer sb = new StringBuffer("get");
        sb.append(String.valueOf(name.charAt(0)).toUpperCase(Locale.ENGLISH));
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    private static String toBooleanGetterMethodName(String name) {
        StringBuffer sb = new StringBuffer("is");
        sb.append(String.valueOf(name.charAt(0)).toUpperCase(Locale.ENGLISH));
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    private PropertyUtils() {
        super();
    }
}
