package org.unitedfront2.domain;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * AJEg؃NXłB
 *
 * @author kurokkie
 *
 */
public class AccountValidator implements Serializable {

    /** ftHg̃[AhX̍ő啶 */
    public static final int DEFAULT_MAIL_ADDR_MAX_LENGTH = 128;

    /** ftHg̃pX[h̍ŏ */
    public static final int DEFAULT_PASSWORD_MIN_LENGTH = 4;

    /** ftHg̃pX[h̍ő啶 */
    public static final int DEFAULT_PASSWORD_MAX_LENGTH = 64;

    /** ftHg̃pX[h̐K\ */
    public static final String DEFAULT_PASSWORD_REGEX = "[\\p{Graph}]*";

    /** VAԍ */
    private static final long serialVersionUID = -8890595145191662607L;

    /** [AhX̍ő啶 */
    private int mailAddrMaxLength = DEFAULT_MAIL_ADDR_MAX_LENGTH;

    /** pX[h̍ŏ */
    private int passwordMinLength = DEFAULT_PASSWORD_MIN_LENGTH;

    /** pX[h̍ő啶 */
    private int passwordMaxLength = DEFAULT_PASSWORD_MAX_LENGTH;

    /** pX[h̐K\ */
    private String passwordRegex = DEFAULT_PASSWORD_REGEX;

    /** AJEge[u */
    private transient AccountTable accountTable;

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("mailAddrMaxLength", mailAddrMaxLength)
            .append("passwordMinLength", passwordMinLength)
            .append("passwordMaxLength", passwordMaxLength)
            .append("passwordRegex", passwordRegex).toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof AccountValidator)) {
            return false;
        }
        AccountValidator castOther = (AccountValidator) other;
        return new EqualsBuilder()
            .append(mailAddrMaxLength, castOther.mailAddrMaxLength)
            .append(passwordMinLength, castOther.passwordMinLength)
            .append(passwordMaxLength, castOther.passwordMaxLength)
            .append(passwordRegex, castOther.passwordRegex).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(mailAddrMaxLength)
            .append(passwordMinLength)
            .append(passwordMaxLength)
            .append(passwordRegex).toHashCode();
    }

    /**
     * [AhX̌؂s܂B
     *
     * @param account AJEg
     * @require ${mailAddr} is not blank.
     * @require ${mailAddr.length} <= {@link #mailAddrMaxLength}
     * @require ${mailAddr} has not around spaces.
     * @require ${mailAddr} is mail address.
     * @throws ValidationException ؃G[
     */
    public void validateMailAddr(Account account) throws ValidationException {
        String mailAddr = account.getMailAddr();
        Validate.notBlank(mailAddr);
        Validate.maxLength(mailAddr, mailAddrMaxLength);
        Validate.notAroundSpaces(mailAddr);
        Validate.mailAddr(mailAddr);
        Account found = accountTable.findByMailAddr(mailAddr);
        if (found != null && !account.identify(found)) {
            throw new ValidationException(
                    "account.validation.mailAddrUserdByOther", null,
                    "The mail address '" + mailAddr + "' is used by other.");
        }
    }

    /**
     * ÍÕpX[ȟ؂s܂B<p>
     *
     * ؓe
     * <ul>
     *   <li>K{</li>
     *   <li>ŏ</li>
     *   <li>ő啶</li>
     *   <li>K\</li>
     * </ul>
     *
     * @param account AJEg
     * @throws ValidationException ؃G[
     */
    public void validatePassword(Account account) throws ValidationException {
        if (account.isEncrypted()) {
            throw new IllegalArgumentException("The account [" + account
                    + "] is encripted.");
        }
        String password = account.getPlainPassword();
        Validate.notBlank(password);
        Validate.lengthInRange(password, passwordMinLength,
            passwordMaxLength);
        Validate.match(password, passwordRegex);
    }

    public int getMailAddrMaxLength() {
        return this.mailAddrMaxLength;
    }

    public void setMailAddrMaxLength(int mailAddrMaxLength) {
        this.mailAddrMaxLength = mailAddrMaxLength;
    }

    public int getPasswordMaxLength() {
        return passwordMaxLength;
    }

    public void setPasswordMaxLength(int passwordMaxLength) {
        this.passwordMaxLength = passwordMaxLength;
    }

    public int getPasswordMinLength() {
        return passwordMinLength;
    }

    public void setPasswordMinLength(int passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
    }

    public String getPasswordRegex() {
        return passwordRegex;
    }

    public void setPasswordRegex(String passwordRegex) {
        this.passwordRegex = passwordRegex;
    }

    public void setAccountTable(AccountTable accountTable) {
        this.accountTable = accountTable;
    }
}
