#ifndef PARAMETER_WRAPPER
#define PARAMETER_WRAPPER

#include "parameter.h"

/*!
 * check whether integer data exists.
 * @param[in]	comp	section TAG
 * @param[in]	*key	key string
 * @return	1 = exist setting value / 0 = non exist setting value
 */
inline int parameter_is_int_exist(const PARAMETER_COMPONENT_TAG comp, const char* key)
{
	if (l7vs::Parameter::getInstance().isIntExist(comp, key)) {
		return 1;
	}
	return 0;
}

/*!
 * check whether character data exists.
 * @param[in]	comp	section TAG
 * @param[in]	*key	key string
 * @return	1 = exist setting value / 0 = non exist setting value
 */
inline int parameter_is_char_exist(const PARAMETER_COMPONENT_TAG comp, const char* key)
{
	if (l7vs::Parameter::getInstance().isStringExist(comp, key)) {
		return 1;
	}
	return 0;
}

/*!
 * get integer data.
 * @param[in]	comp	section TAG
 * @param[in]	*key	key string
 * @return	value
 */
inline int parameter_get_int_value(const PARAMETER_COMPONENT_TAG comp, const char* key)
{
	return l7vs::Parameter::getInstance().getIntValue(comp, key);
}

/*!
 * get character data.
 * @param[in]	comp	section TAG
 * @param[in]	*key	key string
 * @return	value
 */
inline const char* parameter_get_char_value(const PARAMETER_COMPONENT_TAG comp, const char* key)
{
	return (l7vs::Parameter::getInstance().getStringValue(comp, key)).c_str();
}

/*!
 * reload config file
 * @param[in]	comp	section TAG
 * @return	0 = success read file / -1 = failure read file
 */
inline int parameter_reread_file(const PARAMETER_COMPONENT_TAG comp)
{
	if (l7vs::Parameter::getInstance().rereadFile(comp)) {
		return 0;
	}
	return -1;
}

/*!
 * set-parameter function pointer relates component-tag
 * @param[in]	comp	section TAG
 * @param[in]	p_func	function pointer
 */
inline void parameter_register_function_pointer(const PARAMETER_COMPONENT_TAG comp, void(*p_func)())
{
	l7vs::Parameter::getInstance().registerFunctionPointer(comp, p_func);
}

#endif	//PARAMETER_WRAPPER

