/*
 * @file  packet_editor.h
 * @brief Packet Editor Header
 *
 * Copyright (C) 2009  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef __PACKET_EDITOR_H__
#define __PACKET_EDITOR_H__

#include <vector>
#include "logger_wrapper.h"
#include "sslproxy.h"
#include "sslproxysession.h"
#include "http_message.h"
#include "http_request.h"
#include "http_response.h"

class packet_editor
{
private:
    const sslproxy_session* session;
    void expand_macro(std::string&);
    std::vector<std::string> split(const std::string&, const std::string&, int);

public:
    packet_editor(const sslproxy_session*);
    ~packet_editor();
    void edit_client(char*, size_t&);
    void edit_server(char*, size_t&);
};

#endif //__PACKET_EDITOR_H__
