package org.ultramonkey.l7.model;

import org.apache.log4j.Logger;

/**
 * 
 * <p>class FileNotReadException</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class FileNotReadException extends Exception {
	static final long serialVersionUID = 1L;

	private Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
	
	protected String fileName = "";

	protected int errno = 0;

	protected String errMessage = "";

	/**
	 * 
	 * Constructor
	 *
	 */
	public FileNotReadException() {
        // --- debug log (constructor) ---
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11045 class FileNotReadException created.");
        }
        // --- debug log (constructor) ---
	}

	/**
	 * 
	 * <p> getFileName method</p>
	 *
	 * @return
	 */
	public String getFileName() {
		// --- debug log (in/out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11046 FileNotReadException::getFileName() in");
            ioFileLogger.debug("11047 FileNotReadException::getFileName() out return=\"" + this.fileName + "\"");
		}
		// --- debug log (in/out method) ---
		return this.fileName;
	}

	/**
	 * 
	 * <p> setFileName method</p>
	 *
	 * @param fileName
	 */
	public void setFileName(String fileName) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11048 FileNotReadException::setFileName(String fileName) in fileName=\"" + fileName + "\"");
		}
		// --- debug log (in method) ---

		this.fileName = fileName;

		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11049 FileNotReadException::getFileName(String fileName) out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * 
	 * <p> getErrno method</p>
	 *
	 * @return
	 */
	public int getErrno() {
		// --- debug log (in/out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11050 FileNotReadException::getErrno() in");
            ioFileLogger.debug("11051 FileNotReadException::getErrno() out return=" + this.errno);
		}
		// --- debug log (in/out method) ---
		return errno;
	}

	/**
	 * 
	 * <p> setErrNo method</p>
	 *
	 * @param errno
	 */
	public void setErrNo(int errno) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11052 FileNotReadException::setErrno(String errno) in errno=" + errno);
		}
		// --- debug log (in method) ---
		
		this.errno = errno;

		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11053 FileNotReadException::getErrno(String errno) out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * 
	 * <p> getErrMessage method</p>
	 *
	 * @return
	 */
	public String getErrMessage() {
		// --- debug log (in/out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11054 FileNotReadException::getErrMessage() in");
            ioFileLogger.debug("11055 FileNotReadException::getErrMessage() out return=\"" + this.errMessage + "\"");
		}
		// --- debug log (in/out method) ---
		return errMessage;
	}

	/**
	 * 
	 * <p> setErrMessage method</p>
	 *
	 * @param errMessage
	 */
	public void setErrMessage(String errMessage) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11056 FileNotReadException::setErrMessage(String errMessage) in errMessage=\"" + errMessage + "\"");
		}
		// --- debug log (in method) ---

		this.errMessage = errMessage;
		
		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
			ioFileLogger.debug("11057 FileNotReadException::setErrMessage(String errMessage) out");
		}
		// --- debug log (out method) ---
	}
}
