package org.ultramonkey.l7.controller;

import java.util.Date;
import java.io.Serializable;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>class LogFileData</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class LogFileData implements Serializable {
    static final long serialVersionUID = 1;

    /**
     * file name (ex. l7vsd.log, l7vsadm.log.2)
     */
    public String fileName;
    
    /**
     * file path include file name (ex. /var/log/l7vsd.log.4)
     */
    public String filePath;
    
    /**
     * file size
     */
	public long size;
	
	/**
	 * file mdate
	 */
	public Date time;
	
	/**
	 * 
	 * Constructor
	 *
	 */
	public LogFileData() {
        // --- debug log (constructor) ---
		Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11520 class LogFileData created.");
        }
        // --- debug log (constructor) ---

        this.fileName = null;
		this.filePath = null;
		this.size = 0;
		this.time = new Date();
	}
	
	/**
	 * 
	 * Constructor
	 *
	 * @param fileName
	 * @param filePath
	 * @param size
	 * @param time
	 */
	public LogFileData(String fileName, String filePath, long size, Date time) {
        // --- debug log (constructor) ---
		Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11521 class LogFileData created.");
        }
        // --- debug log (constructor) ---

		this.fileName = fileName;
		this.filePath = filePath;
		this.size = size;
		this.time = time;
	}
	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public String toString() {
		return
			"fileName=\"" + this.fileName + "\", " +
			"filePath=\"" + this.filePath + "\", " +
			"size=" + this.size + ", " +
			"time=(" + this.time + ")";
	}
}
