package org.ultramonkey.l7.controller;

import java.io.File;
import java.util.Date;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.FileNotReadException;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>class L7vsLogController</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class L7vsLogController {

	private Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);

	private static String GUI_LOG = "/var/log/l7vs/l7gui.log";
	private static String SYNC_LOG = "/var/log/l7vs/l7sync.log";
	
	/**
	 * 
	 * <p> getData method</p>
	 *
	 * @return log setting data.
	 */
	public LogData getData() {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
			ioFileLogger.debug("11504 L7vsLogController::getData() in");
		}
		// --- debug log (in method) ---

		synchronized (this) {
			L7vsConfController confController = new L7vsConfController();
			DirectorController direController = new DirectorController();
			ClusterController haController = new ClusterController();
			L7vsAdmController admController = new L7vsAdmController();
			L7vsConfData cf = null;
			DirectorData dd = null;
			ClusterData cd = null;
			L7vsAdmData ad = null;
			LogData logData = new LogData();
			try {
				cf = confController.getConfData();
				dd = direController.getDirectorData();
				cd = haController.getData();
				ad = admController.getData();
	
				logData.admLog = setLogfile(cf.logger.admLog);
				
				logData.lbLog = setLogfile(cf.logger.lbLog);
				logData.lbLog.logLevel = ad.l7vsdLogLevel;
				
				logData.snmpLog = setLogfile(cf.logger.snmpLog);
				logData.snmpLog.logLevel = ad.snmpLogLevel;

				cf.logger.directorLog.fileName = dd.logfile.replaceAll("\"", "");
				logData.directorLog = setLogfile(cf.logger.directorLog);
				
				cf.logger.guiLog.fileName = GUI_LOG;
				logData.guiLog = setLogfile(cf.logger.guiLog);
				
				cf.logger.haLog.fileName = cd.logFileName;
				logData.haLog = setLogfile(cf.logger.haLog);
				
				cf.logger.syncLog.fileName = SYNC_LOG;
				logData.syncLog = setLogfile(cf.logger.syncLog);
			} catch (FileNotReadException e) {
				ioFileLogger.error("41216 Exception occured: " + e.getMessage());
				logData = null;
			} catch (Exception e) {
				ioFileLogger.error("41217 Exception occured: " + e.getMessage());
				logData = null;
			}
	
			// --- debug log (out method) ---
			if (ioFileLogger.isDebugEnabled()) {
				ioFileLogger.debug("11505 L7vsLogController::getData() out return=("
						+ logData + ")");
			}
			// --- debug log (out method) ---
			return logData;
		}
	}

	protected LogSet setLogfile(LogSet logSet) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf
					.append("L7vsLogController::setLogfile(LogSet logSet) in ");
			buf.append("cfLogSet=(" + logSet + ")");
			ioFileLogger.debug("11506 " + buf.toString());
		}
		// --- debug log (in method) ---

		int suffix = 0;
		while (true) {
			String path = logSet.fileName;
			if (suffix > 0)
				path += "." + suffix;

			try {
				File log = new File(path);
				if (log.isFile())
					logSet.logFiles.add(new LogFileData(log.getName(),
					log.getAbsolutePath(), log.length(),
					new Date(log.lastModified())));
				else
					break;
			} catch (NullPointerException e) {
				ioFileLogger.error("41218 Exception occured: " + e.getMessage());
			} catch (Exception e) {
				ioFileLogger.error("41219 Exception occured: " + e.getMessage());
			}

			suffix++;
		}
		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
			ioFileLogger.debug("11507 L7vsLogController::setLogfile() out return=(" + logSet + ")");
		}
		// --- debug log (out method) ---
		
		return logSet;
	}
}
