package org.ultramonkey.l7.controller;

import java.io.Serializable;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>
 * class EndPoint
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author tanuma
 */
public class EndPoint implements Serializable {
	static final long serialVersionUID = 1L;

	/**
	 * IP address
	 */
	public String host;

	/**
	 * Port number
	 */
	public String port;

	/**
	 * Weight
	 */
	public int weight;

	/**
	 * Active connections
	 */
	public long actConn;

	/**
	 * Inactive connections
	 */
	public long inActConn;

	/**
	 * 
	 * Constructor
	 * 
	 */
	public EndPoint() {
        // --- debug log (constructor) ---
		Logger vsLogger = Logger.getLogger(LogCategorySet.GUI_VIRTUALSERVICE);
        if (vsLogger.isDebugEnabled()) {
            vsLogger.debug("11513 class EndPoint created.");
        }
        // --- debug log (constructor) ---

		host = "";
		port = "";
		weight = 0;
		actConn = 0;
		inActConn = 0;
	}

	/**
	 * 
	 * Constructor for real server
	 * 
	 * @param host
	 * @param port
	 * @param weight
	 * @param actConn
	 * @param inActConn
	 */
	public EndPoint(String host, String port, int weight, long actConn,
			long inActConn) {
        // --- debug log (constructor) ---
		Logger vsLogger = Logger.getLogger(LogCategorySet.GUI_VIRTUALSERVICE);
        if (vsLogger.isDebugEnabled()) {
            vsLogger.debug("11514 class EndPoint created.");
        }
        // --- debug log (constructor) ---

        if (host == null)
			this.host = "";
		else
			this.host = new String(host);
		if (port == null)
			this.port = "";
		else
			this.port = new String(port);
		this.weight = weight;
		this.actConn = actConn;
		this.inActConn = inActConn;
	}

	/**
	 * 
	 * Constructor for virtual service, sorry server
	 * 
	 * @param host
	 * @param port
	 */
	public EndPoint(String host, String port) {
        // --- debug log (constructor) ---
		Logger vsLogger = Logger.getLogger(LogCategorySet.GUI_VIRTUALSERVICE);
        if (vsLogger.isDebugEnabled()) {
            vsLogger.debug("11515 class EndPoint created.");
        }
        // --- debug log (constructor) ---

        if (host == null)
			this.host = "";
		else
			this.host = new String(host);
		if (port == null)
			this.port = "";
		else
			this.port = new String(port);
		this.weight = 0;
		this.actConn = 0;
		this.inActConn = 0;
	}

	/**
	 * 
	 * Copy Constructor
	 * 
	 * @param e
	 */
	public EndPoint(EndPoint e) {
        // --- debug log (constructor) ---
		Logger vsLogger = Logger.getLogger(LogCategorySet.GUI_VIRTUALSERVICE);
        if (vsLogger.isDebugEnabled()) {
            vsLogger.debug("11516 class EndPoint created.");
        }
        // --- debug log (constructor) ---

        if (e == null) {
			host = "";
			port = "";
			weight = 0;
			actConn = 0;
			inActConn = 0;
		} else {
			if (e.host != null)
				this.host = new String(e.host);
			if (e.port != null)
				this.port = new String(e.port);
			this.weight = e.weight;
			this.actConn = e.actConn;
			this.inActConn = e.inActConn;
		}
	}

	/**
	 * 
	 * <p>
	 * equals method
	 * </p>
	 * 
	 * @param e
	 * @return
	 */
	public boolean equals(EndPoint e) {
        // --- debug log (in method) ---
		Logger vsLogger = Logger.getLogger(LogCategorySet.GUI_VIRTUALSERVICE);
        if (vsLogger.isDebugEnabled()) {
            vsLogger.debug("11517 EndPoint::equals(EndPoint e) in e=(" + e + ")");
        }
        // --- debug log (in method) ---

		if (e != null && this.host.equals(e.host) && this.port.equals(e.port)) {
	        // --- debug log (out method) ---
	        if (vsLogger.isDebugEnabled()) {
	            vsLogger.debug("11518 EndPoint::equals(EndPoint e) out return=true");
	        }
	        // --- debug log (out method) ---
			return true;
		}

        // --- debug log (out method) ---
        if (vsLogger.isDebugEnabled()) {
            vsLogger.debug("11519 EndPoint::equals(EndPoint e) out return=false");
        }
        // --- debug log (out method) ---
		return false;
	}
	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public String toString() {
		return
			"host=\"" + host + "\", " +
			"port=\"" + port + "\", " +
			"weight=" + weight + ", " +
			"actConn=" + actConn + ", " +
			"inActConn=" + inActConn;
	}
}
