package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SyncCategoryIdSet;

/**
 * 
 * <p>
 * class SaveStateServlet
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author kubota
 */
public class SyncStateServlet extends org.ultramonkey.l7.view.L7guiServletBase {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public SyncStateServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11431 class SyncStateServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("SyncStateServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11432 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11433 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11434 SyncStateServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11435 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11436 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---
		
		// check login session
		super.doPost(request, response);

		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41191, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11437 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// get checkbox Category Data & button Mode
        request.setCharacterEncoding("UTF-8");
		String selectCheck[] = request.getParameterValues("sync_category");
		String button_mode = request.getParameter("button");
		if (button_mode == null || button_mode.equals(ButtonMode.SAVESYNC) == false) {
			MessageView error = new MessageView(41192, LogCategorySet.GUI_SYNC, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11438 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		if (selectCheck == null) {
			MessageView error = new MessageView(21084, LogCategorySet.GUI_SYNC,
					Message.SYNC_CATEGORY_SELECT_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.SYNC);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11439 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		HashSet<Integer> syncCategory = new HashSet<Integer>();

		for (int i = 0; i < selectCheck.length; i++) {
			try {
				int categoryNum = SyncCategoryIdSet
						.toCategoryId(selectCheck[i]);
				syncCategory.add(categoryNum);
			} catch (MessageView mem) {
				MessageView error = new MessageView(21085, LogCategorySet.GUI_SYNC,
						Message.SYNC_CATEGORY_SELECT_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.SYNC);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11440 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}
		}

		CommandExecuter thread = new CommandExecuter(session);

		try {
			thread.setExecute(ExecuteMode.SYNC, syncCategory);
			thread.start();
		} catch (Exception e) {
			MessageView error = new MessageView(41193, LogCategorySet.GUI_SYNC, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11441 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		response.sendRedirect(RedirectPages.SYNC_EXECUTIVE);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11442 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}
}
