package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;
import org.ultramonkey.l7.model.MessageView;

/**
 * Servlet implementation class for Servlet: ReplicationRunServlet
 *
 */
 public class ReplicationRunServlet extends L7guiServletBase {
	 static final long serialVersionUID = 1L;	
	 
	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public ReplicationRunServlet() {
		super();
        // --- debug log (constructor) ---
        if (logger.isDebugEnabled()) {
            logger.debug("11457 class ReplicationRunServlet created.");
        }
        // --- debug log (constructor) ---
	}   	
	
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("ReplicationRunServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11458 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11459 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11460 ReplicationRunServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}  	
		
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("ReplicationRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11461 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11462 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---
	
		// check login session
		super.doPost(request, response);
		
		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41200, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11463 ReplicationRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
				
        request.setCharacterEncoding("UTF-8");
		String buttonMode = request.getParameter("button_immediate");
		if ((buttonMode != null) && (buttonMode.equals(ButtonMode.REP_EXECUTE))) {
			CommandExecuter thread = new CommandExecuter(session);
			try {
				thread.setExecute(ExecuteMode.REP_START);
				thread.start();
			}
			catch(Exception e) {
				MessageView error = new MessageView(41201, LogCategorySet.GUI_REPLICATION,
						Message.UNEXPECTED_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
					logger.debug("11464 ReplicationRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}
		}
		else {
			MessageView error = new MessageView(41202, LogCategorySet.GUI_REPLICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11465 ReplicationRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
	
		response.sendRedirect(RedirectPages.REPLICATION_EXECUTIVE);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11466 ReplicationRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}
}
