package org.ultramonkey.l7.view;

import java.io.Serializable;
import java.util.HashSet;

import javax.servlet.http.HttpSession;

import org.ultramonkey.l7.controller.*;
import org.ultramonkey.l7.model.*;

public class CommandExecuter extends Thread implements Serializable {
	static final long serialVersionUID = 1L;

	ExecuteMode mode;

	Object DataClass;

	Object OrgDataClass;

	Object NewDataClass;

	HttpSession session;

	public CommandExecuter(HttpSession session) {
		this.session = session;
		this.mode = null;
		this.DataClass = null;
		this.OrgDataClass = null;
		this.NewDataClass = null;

	}

	private void setThreadStatus(MessageView mv) {
		session.setAttribute(SessionKeys.COMMAND_MESSAGE, mv);
	}

	private void setThreadStatus(String st) {
		session.setAttribute(SessionKeys.THREAD_STATUS, st);
	}

	private void setThreadStatus(String st, String mes) {
		session.setAttribute(SessionKeys.THREAD_STATUS, st);
	}

	public void setExecute(ExecuteMode mode, DirectorData DataClass)
			throws IllegalArgumentException {
		if (DataClass == null) {
			throw (new IllegalArgumentException(
					"Exception DirectorData is null."));
		}
		this.mode = mode;
		this.DataClass = DataClass;
	}

	public void setExecute(ExecuteMode mode, VirtualSetting DataClass)
			throws IllegalArgumentException {
		if (DataClass == null) {
			throw (new IllegalArgumentException(
					"Exception VirtualSettingData is null."));
		}
		this.mode = mode;
		this.DataClass = DataClass;

	}

	public void setExecute(ExecuteMode mode, VirtualSetting OrgDataClass,
			VirtualSetting NewDataClass) throws IllegalArgumentException {
		if (OrgDataClass == null || NewDataClass == null) {
			throw (new IllegalArgumentException(
					"Exception VirtualSettingData is null."));
		}

		this.mode = mode;
		this.OrgDataClass = OrgDataClass;
		this.NewDataClass = NewDataClass;
	}

	public void setExecute(ExecuteMode mode) {
		this.mode = mode;
	}

	public void setExecute(ExecuteMode mode, ReplicationData DataClass) {
		if (DataClass == null) {
			throw (new IllegalArgumentException(
					"Exception ReplicationData is null."));
		}
		this.mode = mode;
		this.DataClass = DataClass;
	}

	public void setExecute(ExecuteMode mode, LogData DataClass) {
		if (DataClass == null) {
			throw (new IllegalArgumentException("Exception LogDeta is null."));
		}
		this.mode = mode;
		this.DataClass = DataClass;

	}

	public void setExecute(ExecuteMode mode, SnmpAgentData DataClass) {
		if (DataClass == null) {
			throw (new IllegalArgumentException(
					"Exception SnmpAgentData is null."));
		}
		this.mode = mode;
		this.DataClass = DataClass;

	}

	public void setExecute(ExecuteMode mode, HashSet DataClass) {
		if (DataClass == null) {
			throw (new IllegalArgumentException(
					"Exception categoryList is null."));
		}
		this.mode = mode;
		this.DataClass = DataClass;

	}

	private boolean vsRemove(DirectorData dd, VirtualSetting vs) {
		int i;
		for (i = 0; i < dd.virtualSettings.size(); i++) {
			if (vs.isSameService(dd.virtualSettings.elementAt(i))) {
				dd.virtualSettings.remove(i);
				return true;
			}
		}
		return false;
	}

	private boolean vsRemove(L7vsAdmData ad, VirtualSetting vs) {
		int i;
		for (i = 0; i < ad.virtualSettings.size(); i++) {
			if (vs.isSameService(ad.virtualSettings.elementAt(i))) {
				return true;
			}
		}
		return false;
	}

	public void run() {
		boolean result = false;
		boolean sameVs = false;
		String message = "";
		int errno = 0;
		HashSet cset = new HashSet();
		DirectorData dd;
		L7vsAdmData ad;
		setThreadStatus(SessionKeys.THREAD_RUNNING);
		L7guiFramework framework = new L7guiFramework();
		L7vsConfController confController = new L7vsConfController();
		switch (this.mode) {
		case DIRECTOR_SAVE:
			String syntax = framework.checkDirectorData((DirectorData) this.DataClass);
			if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
				errno = 41099;
				if (syntax == null)
					message = Message.WRITE_ERROR_L7DIRECTORD;
				else {
					String[] error = syntax.split("at line \\d+: ", 2);
					if (error.length == 2)
						message = Message.DIRECTOR_SYNTAX_ERROR + ": \"" + error[1] + "\"";
					else
						message = Message.DIRECTOR_SYNTAX_ERROR + " \"" + syntax + "\"";
				}
				result = false;
				break;
			}
			else if (!(result = framework
					.setDirectorData((DirectorData) this.DataClass))) {
				errno = 41100;
				message = Message.WRITE_ERROR_L7DIRECTORD;
				break;
			}
			errno = 21049;
			message = Message.DIRECTOR_SAVE;
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			session.setAttribute(SessionKeys.MONITOR_SYNC_STATE, SessionKeys.NO_SYNC);
			break;

		case DIRECTOR_SAVESYNC:
			syntax = framework.checkDirectorData((DirectorData) this.DataClass);
			if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
				errno = 41101;
				if (syntax == null)
					message = Message.WRITE_ERROR_L7DIRECTORD;
				else {
					String[] error = syntax.split("at line \\d+: ", 2);
					if (error.length == 2)
						message = Message.DIRECTOR_SYNTAX_ERROR + ": \"" + error[1] + "\"";
					else
						message = Message.DIRECTOR_SYNTAX_ERROR + "\"" + syntax + "\"";
				}
				result = false;
				break;
			}
			else if (!(result = framework
					.setDirectorData((DirectorData) this.DataClass))) {
				errno = 41102;
				message = Message.WRITE_ERROR_L7DIRECTORD;
				break;
			}
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			session.setAttribute(SessionKeys.MONITOR_SYNC_STATE, SessionKeys.NO_SYNC);
			cset.add(SyncCategoryIdSet.MONITOR_ID);
			if (!(result = framework.syncExecute(cset))) {
				errno = 41103;
				message = Message.SYNC_ERROR_L7DIRECTORD;
				break;
			}
			errno = 21050;
			message = Message.DIRECTOR_SAVESYNC;
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.SYNC);
			session.setAttribute(SessionKeys.MONITOR_SYNC_STATE, SessionKeys.SYNC);
			break;

		case VS_ADD_APPLY: //
			if (!(result = framework
					.addVirtualSetting((VirtualSetting) this.DataClass))) {
				errno = 41104;
				message = Message.L7VSADM_ERROR;
				break;
			}
			errno = 21051;
			message = Message.VS_ADD_APPLY;
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.NO_SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			break;
			
		case VS_ADD_SAVE: //
			// SAVE
			if ((dd = framework.getDirectorData()) == null) {
				errno = 41105;
				message = Message.DIRECTOR_DATA_ERROR;
				result = false;
				break;
			}
			for (VirtualSetting exist : dd.virtualSettings) {
				if (exist.isSameService((VirtualSetting) DataClass)) {
					sameVs = true;
					break;
				}
			}
			if (sameVs == true) {
				errno = 41106;
				message = Message.VIRTUAL_SERVER_EXIST;
				result = false;
				break;
			}
			dd.virtualSettings.add((VirtualSetting) this.DataClass);
			syntax = framework.checkDirectorData(dd);
			if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
				errno = 41107;
				if (syntax == null)
					message = Message.WRITE_ERROR_L7DIRECTORD;
				else {
					String[] error = syntax.split("at line \\d+: ", 2);
					if (error.length == 2)
						message = Message.DIRECTOR_SYNTAX_ERROR + ": \"" + error[1] + "\"";
					else
						message = Message.DIRECTOR_SYNTAX_ERROR + "\"" + syntax + "\"";
				}
				result = false;
				break;
			}
			else if (!(result = framework.setDirectorData(dd))) {
				errno = 41108;
				message = Message.WRITE_ERROR_L7DIRECTORD;
				break;
			}
			errno = 21052;
			message = Message.VS_ADD_SAVE;
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			break;
			
		case VS_ADD_SAVESYNC: //
			// SAVE
			if ((dd = framework.getDirectorData()) == null) {
				errno = 41109;
				message = Message.DIRECTOR_DATA_ERROR;
				result = false;
				break;
			}
			for (VirtualSetting exist : dd.virtualSettings) {
				if (exist.isSameService((VirtualSetting) DataClass)) {
					sameVs = true;
					break;
				}
			}
			if (sameVs == true) {
				errno = 41110;
				message = Message.VIRTUAL_SERVER_EXIST;
				result = false;
				break;
			}
			dd.virtualSettings.add((VirtualSetting) this.DataClass);
			syntax = framework.checkDirectorData(dd);
			if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
				errno = 41111;
				if (syntax == null)
					message = Message.WRITE_ERROR_L7DIRECTORD;
				else {
					String[] error = syntax.split("at line \\d+: ", 2);
					if (error.length == 2)
						message = Message.DIRECTOR_SYNTAX_ERROR + ": \"" + error[1] + "\"";
					else
						message = Message.DIRECTOR_SYNTAX_ERROR + "\"" + syntax + "\"";
				}
				result = false;
				break;
			}
			else if (!(result = framework.setDirectorData(dd))) {
				errno = 41112;
				message = Message.WRITE_ERROR_L7DIRECTORD;
				break;
			}
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			// SYNC
			cset.add(SyncCategoryIdSet.SERVICE_ID);
			if (!(result = framework.syncExecute(cset))) {
				errno = 41113;
				message = Message.SYNC_ERROR_L7DIRECTORD;
				break;
			}
			errno = 21053;
			message = Message.VS_ADD_SAVESYNC;
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.SYNC);
			break;

		case VS_REMOVE_APPLY: //
			if (!(result = framework
					.delVirtualSetting((VirtualSetting) this.DataClass))) {
				errno = 41114;
				message = Message.L7VSADM_ERROR;
				break;
			}
			errno = 21054;
			message = Message.VS_REMOVE_APPLY;
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.NO_SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			break;

		case VS_REMOVE_SAVE: //
			// SAVE
			if ((dd = framework.getDirectorData()) == null) {
				errno = 41115;
				message = Message.DIRECTOR_DATA_ERROR;
				result = false;
				break;
			}
			if ((ad = framework.getAdmData()) == null) {
				errno = 41116;
				message = Message.L7VSADM_ERROR;
				result = false;
				break;
			}
			result = this.vsRemove(dd, (VirtualSetting) this.DataClass);
			syntax = framework.checkDirectorData(dd);
			if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
				errno = 41117;
				if (syntax == null)
					message = Message.WRITE_ERROR_L7DIRECTORD;
				else {
					String[] error = syntax.split("at line \\d+: ", 2);
					if (error.length == 2)
						message = Message.DIRECTOR_SYNTAX_ERROR + ": \"" + error[1] + "\"";
					else
						message = Message.DIRECTOR_SYNTAX_ERROR + "\"" + syntax + "\"";
				}
				result = false;
				break;
			}
			if (result == false) {
				if(!(result = this.vsRemove(ad, (VirtualSetting) this.DataClass))) {
					errno = 41118;
					message = Message.NO_VS;
					break;
				} else if (!(result = framework.delVirtualSetting((VirtualSetting) this.DataClass))) {
					errno = 41119;
					message = Message.L7VSADM_ERROR;
					break;
				}
				session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.NO_SAVE);
				session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			}
			if (!(result = framework.setDirectorData(dd))) {
				errno = 41120;
				message = Message.WRITE_ERROR_L7DIRECTORD;
				break;
			}
			errno = 21055;
			message = Message.VS_REMOVE_SAVE;
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			break;

		case VS_REMOVE_SAVESYNC: //
			// SAVE
			if ((dd = framework.getDirectorData()) == null) {
				errno = 41121;
				message = Message.DIRECTOR_DATA_ERROR;
				result = false;
				break;
			}
			if ((ad = framework.getAdmData()) == null) {
				errno = 41122;
				message = Message.L7VSADM_ERROR;
				result = false;
				break;
			}
			result = this.vsRemove(dd, (VirtualSetting) this.DataClass);
			syntax = framework.checkDirectorData(dd);
			if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
				errno = 41123;
				if (syntax == null)
					message = Message.WRITE_ERROR_L7DIRECTORD;
				else {
					String[] error = syntax.split("at line \\d+: ", 2);
					if (error.length == 2)
						message = Message.DIRECTOR_SYNTAX_ERROR + ": \"" + error[1] + "\"";
					else
						message = Message.DIRECTOR_SYNTAX_ERROR + "\"" + syntax + "\"";
				}
				result = false;
				break;
			}
			if (result == false) {
				if(!(result = this.vsRemove(ad, (VirtualSetting) this.DataClass))) {
					errno = 41124;
					message = Message.NO_VS;
					break;
				} else if (!(result = framework.delVirtualSetting((VirtualSetting) this.DataClass))) {
					errno = 41125;
					message = Message.L7VSADM_ERROR;
					break;
				}
				session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.NO_SAVE);
				session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			}
			if (!(result = framework.setDirectorData(dd))) {
				errno = 41126;
				message = Message.WRITE_ERROR_L7DIRECTORD;
				break;
			}
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);

			// SYNC
			cset.add(SyncCategoryIdSet.SERVICE_ID);
			if (!(result = framework.syncExecute(cset))) {
				errno = 41127;
				message = Message.SYNC_ERROR_L7DIRECTORD;
				break;
			}
			errno = 21056;
			message = Message.VS_REMOVE_SAVESYNC;
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.SYNC);
			break;

		case VS_MODIFY_APPLY: //
			if (!(result = framework
					.delVirtualSetting((VirtualSetting) this.OrgDataClass))) {
				errno = 41128;
				message = Message.L7VSADM_ERROR;
				break;
			}
			if (!(result = framework
					.addVirtualSetting((VirtualSetting) this.NewDataClass))) {
				errno = 41129;
				message = Message.L7VSADM_ERROR;
				break;
			}
			errno = 21057;
			message = Message.VS_MODIFY_APPLY;
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.NO_SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			break;

		case VS_MODIFY_SAVE: //
			if ((dd = framework.getDirectorData()) == null) {
				errno = 41130;
				message = Message.DIRECTOR_DATA_ERROR;
				result = false;
				break;
			}
			if ((ad = framework.getAdmData()) == null) {
				errno = 41131;
				message = Message.L7VSADM_ERROR;
				result = false;
				break;
			}
			result = this.vsRemove(dd, (VirtualSetting) this.OrgDataClass);
			for (VirtualSetting exist : dd.virtualSettings) {
				if (exist.isSameService((VirtualSetting) NewDataClass)) {
					sameVs = true;
					break;
				}
			}
			if (sameVs == true) {
				errno = 41132;
				message = Message.VIRTUAL_SERVER_EXIST;
				result = false;
				break;
			}
			dd.virtualSettings.add((VirtualSetting) this.NewDataClass);
			syntax = framework.checkDirectorData(dd);
			if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
				errno = 41133;
				if (syntax == null)
					message = Message.WRITE_ERROR_L7DIRECTORD;
				else {
					String[] error = syntax.split("at line \\d+: ", 2);
					if (error.length == 2)
						message = Message.DIRECTOR_SYNTAX_ERROR + ": \"" + error[1] + "\"";
					else
						message = Message.DIRECTOR_SYNTAX_ERROR + "\"" + syntax + "\"";
				}
				result = false;
				break;
			}
			if (result == false) {
				if(!(result = this.vsRemove(ad, (VirtualSetting) this.OrgDataClass))) {
					errno = 41134;
					message = Message.NO_VS;
					break;
				} else if (!(result = framework.delVirtualSetting((VirtualSetting) this.OrgDataClass))) {
					errno = 41135;
					message = Message.L7VSADM_ERROR;
					break;
				}
				session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.NO_SAVE);
				session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			}
			if (!(result = framework.setDirectorData(dd))) {
				errno = 41136;
				message = Message.WRITE_ERROR_L7DIRECTORD;
				break;
			}
			errno = 21058;
			message = Message.VS_MODIFY_SAVE;
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			break;

		case VS_MODIFY_SAVESYNC: //
			if ((dd = framework.getDirectorData()) == null) {
				errno = 41137;
				message = Message.DIRECTOR_DATA_ERROR;
				result = false;
				break;
			}
			if ((ad = framework.getAdmData()) == null) {
				errno = 41138;
				message = Message.L7VSADM_ERROR;
				result = false;
				break;
			}
			result = this.vsRemove(dd, (VirtualSetting) this.OrgDataClass);
			for (VirtualSetting exist : dd.virtualSettings) {
				if (exist.isSameService((VirtualSetting) NewDataClass)) {
					sameVs = true;
					break;
				}
			}
			if (sameVs == true) {
				errno = 41139;
				message = Message.VIRTUAL_SERVER_EXIST;
				result = false;
				break;
			}
			dd.virtualSettings.add((VirtualSetting) this.NewDataClass);
			syntax = framework.checkDirectorData(dd);
			if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
				errno = 41140;
				if (syntax == null)
					message = Message.WRITE_ERROR_L7DIRECTORD;
				else {
					String[] error = syntax.split("at line \\d+: ", 2);
					if (error.length == 2)
						message = Message.DIRECTOR_SYNTAX_ERROR + ": \"" + error[1] + "\"";
					else
						message = Message.DIRECTOR_SYNTAX_ERROR + "\"" + syntax + "\"";
				}
				result = false;
				break;
			}
			if (result == false) {
				if(!(result = this.vsRemove(ad, (VirtualSetting) this.OrgDataClass))) {
					errno = 41141;
					message = Message.NO_VS;
					break;
				} else if (!(result = framework.delVirtualSetting((VirtualSetting) this.OrgDataClass))) {
					errno = 41142;
					message = Message.L7VSADM_ERROR;
					break;
				}
				session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.NO_SAVE);
				session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			}
			if (!(result = framework.setDirectorData(dd))) {
				errno = 41143;
				message = Message.WRITE_ERROR_L7DIRECTORD;
				break;
			}
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.NO_SYNC);
			// SYNC
			cset.add(SyncCategoryIdSet.SERVICE_ID);
			if (!(result = framework.syncExecute(cset))) {
				errno = 41144;
				message = Message.SYNC_ERROR_L7DIRECTORD;
				break;
			}
			errno = 21059;
			message = Message.VS_MODIFY_SAVESYNC;
			session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.SYNC);
			break;

		case CLUSTER_SWITCHORVER: //
			if (!(result = framework.setClusterMode())) {
				errno = 41145;
				message = Message.CLUSTER_COMMAND_ERROR;
			} else {
				errno = 21060;
				message = Message.CLUSTER_SWITCHORVER;
			}
			break;

		case REP_MASTER: //
			if (!(result = framework
					.setReplicationMode(ReplicationStatus.MASTER))) {
				errno = 41146;
				message = Message.L7VSADM_ERROR;
			} else {
				errno = 21061;
				message = Message.REP_MASTER;
			}
			break;

		case REP_MASTER_STOP: //
			if (!(result = framework
					.setReplicationMode(ReplicationStatus.MASTER_STOP))) {
				errno = 41147;
				message = Message.L7VSADM_ERROR;
			} else {
				errno = 21062;
				message = Message.REP_MASTER_STOP;
			}
			break;

		case REP_SLAVE: //
			if (!(result = framework
					.setReplicationMode(ReplicationStatus.SLAVE))) {
				errno = 41148;
				message = Message.L7VSADM_ERROR;
			} else {
				errno = 21063;
				message = Message.REP_SLAVE;
			}
			break;

		case REP_SLAVE_STOP: //
			if (!(result = framework
					.setReplicationMode(ReplicationStatus.SLAVE_STOP))) {
				errno = 41149;
				message = Message.L7VSADM_ERROR;
			} else {
				errno = 21064;
				message = Message.REP_SLAVE_STOP;
			}
			break;

		case REP_INFO_SAVE: //
			if (!(result = framework
					.setReplicationData((ReplicationData) DataClass))) {
				errno = 41150;
				message = Message.WRITE_ERROR_L7VS;
			} else {
				errno = 21065;
				message = Message.REP_INFO_SAVE;
				session.setAttribute(SessionKeys.REP_SYNC_STATE, SessionKeys.NO_SYNC);
			}
			break;

		case REP_INFO_SAVESYNC: //
			if (result = framework
					.setReplicationData((ReplicationData) DataClass)) {
				session.setAttribute(SessionKeys.REP_SYNC_STATE, SessionKeys.NO_SYNC);
				// SYNC
				cset.add(SyncCategoryIdSet.REPLICATION_INFO_ID);
				if (!(result = framework.syncExecute(cset))) {
					errno = 41151;
					message = Message.SYNC_ERROR_L7VS;
				} else {
					errno = 21066;
					message = Message.REP_INFO_SAVESYNC;
					session.setAttribute(SessionKeys.REP_SYNC_STATE, SessionKeys.SYNC);
				}
			} else {
				errno = 41152;
				message = Message.WRITE_ERROR_L7VS;
			}
			break;

		case REP_START://
			if (!(result = framework.dumpReplicationData())) {
				errno = 41153;
				message = Message.L7VSADM_ERROR;
			} else {
				errno = 21067;
				message = Message.REP_START;
			}
			break;

		case LOGLEVEL_CHANGE_APPLY:
			LogData ld = (LogData) DataClass;
			if (! (result = framework.setLogLevel(ld.lbLog.logLevel))) {
				errno = 41154;
				message = Message.L7VSADM_ERROR;
			}
			else if (! (result = framework.setLogLevel(ld.snmpLog.logLevel))) {
				errno = 41155;
				message = Message.L7VSADM_ERROR;
			} else {
				errno = 21068;
				message = Message.LOGLEVEL_CHANGE_APPLY;
				session.setAttribute(SessionKeys.LOG_SAVE_STATE, SessionKeys.NO_SAVE);
				session.setAttribute(SessionKeys.LOG_SYNC_STATE, SessionKeys.NO_SYNC);
			}
			break;

		case LOGLEVEL_CHANGE_SAVE: //
			try {
				L7vsConfData cf = confController.getConfData();
				cf.logger = (LogData) DataClass;
				if (! (result = framework.setL7vsConfData(cf))) {
					errno = 41156;
					message = Message.WRITE_ERROR_L7VS;
				} else if (! (result = framework.reloadAdmData(L7vsConfCategory.LOGGER))) {
					errno = 41157;
					message = Message.L7VSADM_ERROR;
				} else if (! (result = framework.reloadAdmData(L7vsConfCategory.SNMPAGENT))) {
					errno = 41158;
					message = Message.L7VSADM_ERROR;
				} else {
					errno = 21069;
					message = Message.LOGLEVEL_CHANGE_SAVE;
					session.setAttribute(SessionKeys.LOG_SAVE_STATE, SessionKeys.SAVE);
					session.setAttribute(SessionKeys.LOG_SYNC_STATE, SessionKeys.NO_SYNC);
				}
			} catch (Exception e) {
				errno = 41159;
				message = Message.L7VS_CONF_DATA_ERROR;
				result = false;
			}
			break;
		
		case LOGLEVEL_CHANGE_SAVESYNC: //
			try {
				L7vsConfData cf = confController.getConfData();
				cf.logger = (LogData) DataClass;
				if (! (result = framework.setL7vsConfData(cf))) {
					errno = 41160;
					message = Message.WRITE_ERROR_L7VS;
				} else if (! (result = framework.reloadAdmData(L7vsConfCategory.LOGGER))) {
					errno = 41161;
					message = Message.L7VSADM_ERROR;
				} else if (! (result = framework.reloadAdmData(L7vsConfCategory.SNMPAGENT))) {
					errno = 41162;
					message = Message.L7VSADM_ERROR;
				} else {
					session.setAttribute(SessionKeys.LOG_SAVE_STATE, SessionKeys.SAVE);
					session.setAttribute(SessionKeys.LOG_SYNC_STATE, SessionKeys.NO_SYNC);
					cset.add(SyncCategoryIdSet.LOG_ALL_ID);
					if (! (result = framework.syncExecute(cset))) {
						errno = 41163;
						message = Message.SYNC_ERROR_L7VS;
					} else {
						errno = 21070;
						message = Message.LOGLEVEL_CHANGE_SAVESYNC;
						session.setAttribute(SessionKeys.LOG_SYNC_STATE, SessionKeys.SYNC);
					}
				}
			} catch (Exception e) {
				errno = 41164;
				message = Message.L7VS_CONF_DATA_ERROR;
				result = false;
			}
			break;

		case SNMP_INFO_SAVE: //
			if (!(result = framework
					.setSnmpAgentData((SnmpAgentData) DataClass))) {
				errno = 41165;
				message = Message.WRITE_ERROR_L7VS;
			} else {
				errno = 21071;
				message = Message.SNMP_INFO_SAVE;
				session.setAttribute(SessionKeys.SNMP_SYNC_STATE, SessionKeys.NO_SYNC);
			}
			break;
		
		case SNMP_INFO_SAVESYNC: //
			if (!(result = framework
					.setSnmpAgentData((SnmpAgentData) DataClass))) {
				errno = 41166;
				message = Message.WRITE_ERROR_L7VS;
				break;
			}
			session.setAttribute(SessionKeys.SNMP_SYNC_STATE, SessionKeys.NO_SYNC);
			// SYNC
			cset.add(SyncCategoryIdSet.SNMP_INFO_ID);
			if (!(result = framework.syncExecute(cset))) {
				errno = 41167;
				message = Message.SYNC_ERROR_L7VS;
			} else {
				errno = 21072;
				message = Message.SNMP_INFO_SAVESYNC;
				session.setAttribute(SessionKeys.SNMP_SYNC_STATE, SessionKeys.SYNC);
			}
			break;

		case SYNC: //
			HashSet<Integer> syncSet = (HashSet<Integer>) DataClass;
			if (!(result = framework.syncExecute(syncSet))) {
				errno = 41168;
				message = Message.SYNC_FAIL;
			} else {
				errno = 21073;
				message = Message.SYNC;
				for (int i : syncSet) {
					switch(i) {
					case SyncCategoryIdSet.L7VSD_LOG_ID:
					case SyncCategoryIdSet.ADM_LOG_ID:
					case SyncCategoryIdSet.SNMP_LOG_ID:
					case SyncCategoryIdSet.LOG_ALL_ID:
						session.setAttribute(SessionKeys.LOG_SYNC_STATE, SessionKeys.SYNC);
						break;
					case SyncCategoryIdSet.REPLICATION_INFO_ID:
						session.setAttribute(SessionKeys.REP_SYNC_STATE, SessionKeys.SYNC);
						break;
					case SyncCategoryIdSet.SNMP_INFO_ID:
						session.setAttribute(SessionKeys.SNMP_SYNC_STATE, SessionKeys.SYNC);
						break;
					case SyncCategoryIdSet.MONITOR_ID:
						session.setAttribute(SessionKeys.MONITOR_SYNC_STATE, SessionKeys.SYNC);
						break;
					case SyncCategoryIdSet.SERVICE_ID:
						session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.SYNC);
						break;
					case SyncCategoryIdSet.USERDATA_ID:
						session.setAttribute(SessionKeys.GUI_SYNC_STATE, SessionKeys.SYNC);
					case SyncCategoryIdSet.ADM_INFO_ID:
					default:
					}
				}
			}
			break;

		default:
			throw (new IllegalArgumentException("Illegal Parameter."));
		}
		MessageView mv = new MessageView();
		mv.setCategory(LogCategorySet.GUI_IO_COMMAND);
		mv.setMessage(message);
		mv.setErrno(errno);
		setThreadStatus(mv);

		if (result != true) {
			setThreadStatus(SessionKeys.THREAD_FAIL);
		} else {
			setThreadStatus(SessionKeys.THREAD_SUCCESS);
		}
		return;
	}
}
