package org.ultramonkey.l7.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;

import javax.mail.internet.MimeUtility;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.controller.L7vsConfData;

/**
 * <p>class Payload</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author momose
 */
public class Payload {
    protected Logger debugLogger = Logger.getLogger(LogCategorySet.SYNC_SYNC);

    protected Logger debugDirectorLogger = Logger
                    .getLogger(LogCategorySet.SYNC_SYNC_DIRECTOR_DATA);

    protected Logger debugL7vsdConfLogger = Logger
                    .getLogger(LogCategorySet.SYNC_SYNC_L7VSDCONF_DATA);

    protected Logger debugUserLogger = Logger
                    .getLogger(LogCategorySet.SYNC_SYNC_USER_DATA);

    // �{�f�B����V���A���C�Y�����Abase64�G���R�[�h�����f�[�^�T�C�Y��i�[����int�ϐ�
    protected int size;

    // ����Ώۂ̃J�e�S��ID��i�[����int�ϐ�
    protected int categoryId;

    // ����Ώۃf�[�^��i�[����Object�ϐ�
    protected Object body;

    // �G���R�[�h��@��i�[����String�萔
    protected final String ENCODING = "base64";

    // �ʐM�f�[�^��size�̃L�[����i�[����String�萔
    protected final String SIZE_KEY_STRING = "size=";

    // �ʐM�f�[�^�̃J�e�S���̃L�[����i�[����String�萔
    protected final String CATEGORY_KEY_STRING = "category=";

    // �ʐM�f�[�^�̃{�f�B���̃L�[����i�[����String�萔
    protected final String BODY_KEY_STRING = "body=";

    // �ʐM�f�[�^�̉�s��i�[����String�萔
    protected final String separator = "\r\n";

    // �T�C�Y�̒l�̌�����i�[����萔
    protected final int SIZE_PADDING_NUMBER = 7;

    // �J�e�S���̒l�̌�����i�[����萔
    protected final int CATEGORY_PADDING_NUMBER = 2;

    // payload�N���X�̍��ڐ��i�T�C�Y�A�J�e�S��ID�A�{�f�B�j
    protected final int ENTRY_NUMBER = 3;

    /**
     * Constructor
     *
     * @param str recieve data
     * @throws MessageView
     */
    public Payload(String[] str) throws MessageView {
        //      debug log(constructor)
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("11175 class Payload created.");
        }

        // �T�C�Y�̃L�[�ƒl��i�[����String�ϐ�
        String sizeStr = str[0];
        // �L�[�ƒl��"="�ŕ���
        String[] sizeSplit = sizeStr.split("=");
        // �擾�����T�C�Y�̒l��size�Ɋi�[
        size = Integer.parseInt(sizeSplit[1]);

        // �J�e�S��ID�̃L�[�ƒl��i�[����String�ϐ�
        String categoryStr = str[1];
        // �L�[�ƒl��"="�ŕ���
        String[] categorySplit = categoryStr.split("=");
        // �擾�����J�e�S��ID�̒l��cateogyId�Ɋi�[
        categoryId = Integer.parseInt(categorySplit[1]);

        // �{�f�B�̃L�[�ƒl��i�[����String�ϐ�
        String bodyStr = str[2];
        // �L�[�ƒl��"="�ŕ���
        String[] bodySplit = bodyStr.split("=", 2);
        // �擾�����{�f�B�̃T�C�Y���r����

        if (bodySplit[1].length() != size) {
            // �f�[�^�̎擾���s�̃��b�Z�[�W��ԋp
            throw new MessageView(40003, LogCategorySet.SYNC_SYNC, Message.SYNC_GET_ERROR
                            + " : payload");
        }

        // �J�e�S��ID��SYNC_OK��SYNC_NG�ȊO�̏ꍇ
        if ((SyncCategoryIdSet.SYNC_OK != categoryId)
                        && (SyncCategoryIdSet.SYNC_NG != categoryId)) {
            // �擾�����{�f�B�̒l��body�Ɋi�[
            body = decodeAndDeserialize(bodySplit[1]);
        }
    }

    /**
     * Constructor
     *
     * @param categoryId  
     * @param userData 
     * @throws MessageView
     */
    public Payload(int categoryId, Vector<UserData> userData) throws MessageView {
        //      debug log(constructor)
        if (debugUserLogger.isDebugEnabled()) {
            debugUserLogger.debug("11176 class Payload created.");
        }
        // �J�e�S��ID��USER_DATA_ID�̏ꍇ
        switch (categoryId) {
        case SyncCategoryIdSet.USERDATA_ID:
            // �T�C�Y�͐ݒ肵�Ȃ�
            size = 0;
            // ��̃J�e�S��ID��categoryId�ɐݒ�
            this.categoryId = categoryId;
            // ���UserData��Object�^�Ƃ���body�ɐݒ�
            setBody((Object) userData);
            break;

        // �f�[�^�N���X�ɑ��݂��Ȃ��J�e�S����w�肵���ꍇ
        default:
            // �J�e�S�������s���ł��郁�b�Z�[�W��ԋp
            throw new MessageView(40004, LogCategorySet.SYNC_SYNC_USER_DATA,
                            Message.SYNC_INVALID_CATEGORY_ID);
        }
    }

    /**
     * Constructor
     *
     * @param categoryId 
     * @param directorData 
     * @throws MessageView
     */
    public Payload(int categoryId, DirectorData directorData) throws MessageView {
        //      debug log(constructor)
        if (debugDirectorLogger.isDebugEnabled()) {
            debugDirectorLogger.debug("11177 class Payload created.");
        }
        switch (categoryId) {
        // �J�e�S��ID��MONITOR_ID��SERVICE_ID�̏ꍇ
        case SyncCategoryIdSet.MONITOR_ID:
        case SyncCategoryIdSet.SERVICE_ID:
        case SyncCategoryIdSet.SYNC_OK:
        case SyncCategoryIdSet.SYNC_NG:
            // �T�C�Y�͐ݒ肵�Ȃ�
            size = 0;
            // ��̃J�e�S��ID��categoryId�ɐݒ�
            this.categoryId = categoryId;
            // ���DirectorData��Object�^�Ƃ���body�ɐݒ�
            setBody((Object) directorData);
            break;

        // �f�[�^�N���X�ɑ��݂��Ȃ��J�e�S����w�肵���ꍇ
        default:
            // �J�e�S�������s���ł��郁�b�Z�[�W��ԋp
            throw new MessageView(40005, LogCategorySet.SYNC_SYNC_DIRECTOR_DATA,
                            Message.SYNC_INVALID_CATEGORY_ID);
        }
    }

    /**
     * Constructor
     * 
     * @param categoryId 
     * @param l7vsConfData 
     * @throws MessageView
     */
    public Payload(int categoryId, L7vsConfData l7vsConfData) throws MessageView {
        //      debug log(constructor)
        if (debugL7vsdConfLogger.isDebugEnabled()) {
            debugL7vsdConfLogger.debug("11178 class Payload created.");
        }
        // �J�e�S��ID��L7VSD_LOG_ID�AADM_LOG_ID�ASNMP_LOG_ID�AREPLICATION_INFO_ID�AADM_INFO_ID�̏ꍇ
        switch (categoryId) {
        case SyncCategoryIdSet.L7VSD_LOG_ID:
        case SyncCategoryIdSet.ADM_LOG_ID:
        case SyncCategoryIdSet.SNMP_LOG_ID:
        case SyncCategoryIdSet.REPLICATION_INFO_ID:
        case SyncCategoryIdSet.SNMP_INFO_ID:
        case SyncCategoryIdSet.ADM_INFO_ID:
        case SyncCategoryIdSet.LOG_ALL_ID:
            // �T�C�Y�͐ݒ肵�Ȃ�
            size = 0;
            // ��̃J�e�S��ID��categoryId�ɐݒ�
            this.categoryId = categoryId;
            // ���L7vsConfData��Object�^�Ƃ���body�ɐݒ�
            setBody((Object) l7vsConfData);
            break;

        // �f�[�^�N���X�ɑ��݂��Ȃ��J�e�S����w�肵���ꍇ
        default:
            // �J�e�S�������s���ł��郁�b�Z�[�W��ԋp
            throw new MessageView(40006, LogCategorySet.SYNC_SYNC_L7VSDCONF_DATA,
                            Message.SYNC_INVALID_CATEGORY_ID);
        }
    }

    /**
     * <p> Gets body.</p>
     *
     * @return body�@
     */
    protected Object getBody() {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getBody() in ");
            debugLogger.debug("11179 " + buf.toString());
        }

        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getBody() out ");
            buf.append("return= " + body.toString());
            debugLogger.debug("11180 " + buf.toString());
        }

        //�@�{�f�B����ԋp
        return body;
    }

    /**
     * <p> Sets body.</p>
     *
     * @param body 
     */
    protected void setBody(Object body) {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::setBody(Object body) in ");
            buf.append("body= " + body.toString());
            debugLogger.debug("11181 " + buf.toString());
        }

        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::setBody(Object body) out ");
            debugLogger.debug("11182 " + buf.toString());
        }
        // body����ݒ�
        this.body = body;
    }

    /**
     * <p> Serializes and encodes data.</p>
     *
     * @return formatted data
     * @throws MessageView
     */
    protected String serializeAndEncode() throws MessageView {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::serializeAndEncode() throws MessageView in ");
            debugLogger.debug("11183 " + buf.toString());
        }

        try {
            // �擾�����f�[�^��V���A���C�Y
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(byteArray);
            outputStream.writeObject(body);
            outputStream.flush();
            outputStream.close();

            // �V���A���C�Y�����f�[�^��Base64�ŃG���R�[�h
            OutputStream base64OutputStream = MimeUtility.encode(byteArray, ENCODING);
            byte[] serializeByte = byteArray.toByteArray();
            byteArray.reset();
            base64OutputStream.write(serializeByte);
            base64OutputStream.close();

            //      debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Payload::serializeAndEncode() throws MessageView out ");
                buf.append("return= " + byteArray.toString());
                debugLogger.debug("11184 " + buf.toString().replaceAll("[\r\n]", ""));
            }
            // �G���R�[�h�����f�[�^��ԋp
            return byteArray.toString().replaceAll("[\r\n]", "");

            // �V���A���C�Y�܂��̓G���R�[�h�Ɏ��s�����ꍇ
        } catch (Exception e) {
            // �V���A���C�Y���s�̃��b�Z�[�W��ԋp
            throw new MessageView(40007, LogCategorySet.SYNC_SYNC,
                            Message.SYNC_ENCODE_ERROR);
        }

    }

    /**
     * <p> Decodes and deserializes data.</p>
     *
     * @param body body data which is serialized and encoded 
     * @return data at body
     * @throws MessageView
     */
    protected Object decodeAndDeserialize(String body) throws MessageView {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf
                            .append("Payload::decodeAndDeserialize(String body) throws MessageView in ");
            buf.append("body= " + body);
            debugLogger.debug("11185 " + buf.toString());
        }

        try {
            // �f�R�[�h�����f�[�^��i�[����byte�z��
            byte[] readBytes = new byte[10000000];

            // body��Base64�Ńf�R�[�h
            InputStream base64InputStream = MimeUtility.decode(new ByteArrayInputStream(
                            body.getBytes()), "base64");
            // �f�R�[�h�����f�[�^��擾
            base64InputStream.read(readBytes);

            // �f�R�[�h�����f�[�^��f�V���A���C�Y���邽�߂�ObjectInputStream�C���X�^���X
            ObjectInputStream inputStream = new ObjectInputStream(
                            new ByteArrayInputStream(readBytes));

            Object result = inputStream.readObject();
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("Payload::decodeAndDeserialize(String body) throws MessageView out ");
                buf.append("return= " + result.toString());
                debugLogger.debug("11186 " + buf.toString());
            }

            // �f�V���A���C�Y�������ʂ�ԋp
            return result;

            // �f�V���A���C�Y�܂��̓f�R�[�h�Ɏ��s�����ꍇ
        } catch (Exception e) {
            // �f�V���A���C�Y���s�̃��b�Z�[�W��ԋp
            throw new MessageView(40008, LogCategorySet.SYNC_SYNC,
                            Message.SYNC_DECODE_ERROR + e);
        }
    }

    /**
     * <p> Formats data.</p>
     *
     * @return formatted data
     * @throws MessageView
     */
    public String[] getMessage() throws MessageView {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getMessage() throws MessageView in ");
            debugLogger.debug("11187 " + buf.toString());
        }

        // Base64�G���R�[�h���A�V���A���C�Y�����{�f�B����i�[����String�ϐ�
        String body = serializeAndEncode();
        // �G���R�[�h�ƃV���A���C�Y��̃{�f�B���̒�����i�[����String�ϐ�
        String sizeNumber = new Integer(body.length()).toString();
        // �J�e�S��ID��i�[����String�ϐ�
        String categoryStr = new Integer(categoryId).toString();

        // ���`��̃T�C�Y��i�[����StringBuffer�C���X�^���X
        StringBuffer sizeBuffer = new StringBuffer();
        //�@�T�C�Y�̃L�[����ǉ�
        sizeBuffer.append(SIZE_KEY_STRING);
        // �T�C�Y��0�p�f�B���O���A�l��ǉ�
        sizeBuffer.append(sizeNumber);
        for (int count = 0; count < SIZE_PADDING_NUMBER - sizeNumber.length(); count++) {
            sizeBuffer.insert(SIZE_KEY_STRING.length(), "0");
        }

        // ���`��̃J�e�S����i�[����StringBuffer�C���X�^���X
        StringBuffer categoryBuffer = new StringBuffer();
        // �J�e�S���̃L�[����ǉ�
        categoryBuffer.append(CATEGORY_KEY_STRING);
        // �J�e�S����0�p�f�B���O���A�l��ǉ�
        categoryBuffer.append(categoryStr);
        for (int count = 0; count < CATEGORY_PADDING_NUMBER - categoryStr.length(); count++) {
            categoryBuffer.insert(CATEGORY_KEY_STRING.length(), "0");
        }

        // ���`��̃{�f�B��i�[����StringBuffer�C���X�^���X
        StringBuffer bodyBuffer = new StringBuffer();
        // �{�f�B�̃L�[����ǉ�
        bodyBuffer.append(BODY_KEY_STRING);
        // �{�f�B�̒l��ǉ�
        bodyBuffer.append(body);

        // Payload�N���X�𐮌`�����f�[�^�i�[����String�^�z��
        String[] messageArray = new String[ENTRY_NUMBER];
        // �T�C�Y��messageArray�Ɋi�[
        messageArray[0] = sizeBuffer.toString();
        // �J�e�S����messageArray�Ɋi�[
        messageArray[1] = categoryBuffer.toString();
        // �{�f�B��messageArray�Ɋi�[
        messageArray[2] = bodyBuffer.toString();

        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getMessage() throws MessageView out ");
            buf.append("return= " + messageArray.toString());
            debugLogger.debug("11188 " + buf.toString());
        }

        // ���`��̏���ԋp
        return messageArray;
    }

    /**
     * <p> Gets UserData from Payload.</p>
     *
     * @return userData 
     */
    public Vector<UserData> getUserData() {
        //      debug log(in method)
        if (debugUserLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getUserData() in ");
            debugUserLogger.debug("11189 " + buf.toString());
        }
        //      debug log(out method)
        if (debugUserLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getUserData() out ");
            buf.append("return= " + ((Vector<UserData>) body).toString());
            debugUserLogger.debug("11190 " + buf.toString());
        }

        // �{�f�B����UserData�^�ɕϊ����ĕԋp
        return (Vector<UserData>) body;
    }

    /**
     * <p> Gets DirectorData from Payload.</p>
     *
     * @return directorData 
     */
    public DirectorData getDirectorData() {
        //      debug log(in method)
        if (debugDirectorLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getDirectorData() in ");
            debugLogger.debug("11191 " + buf.toString());
        }
        //      debug log(out method)
        if (debugDirectorLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getDirectorData() out ");
            buf.append("return= " + ((DirectorData) body).toString());
            debugDirectorLogger.debug("11192 " + buf.toString());
        }
        //      �{�f�B����DirectorData�^�ɕϊ����ĕԋp
        return (DirectorData) body;
    }

    /**
     * <p> Gets L7vsdConfData from Payload.</p>
     *
     * @return l7vsdConfData
     */
    public L7vsConfData getL7vsdConfData() {
        //      debug log(in method)
        if (debugL7vsdConfLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getL7vsdConfData() in ");
            debugL7vsdConfLogger.debug("11193 " + buf.toString());
        }
        //      debug log(out method)
        if (debugL7vsdConfLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getL7vsdConfData() out ");
            buf.append("return= " + ((L7vsConfData) body).toString());
            debugL7vsdConfLogger.debug("11194 " + buf.toString());
        }
        //      �{�f�B����l7vsConfData�^�ɕϊ����ĕԋp
        return (L7vsConfData) body;
    }
}
