package org.ultramonkey.l7.controller;

import java.io.Serializable;
import java.util.Vector;
import java.util.regex.*;

/**
 * 
 * <p>
 * class VirtualSetting
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author tanuma
 */
public class VirtualSetting implements Serializable {
	static final long serialVersionUID = 1;

	/**
	 * virtual service
	 */
	public EndPoint virtual;

	/**
	 * real server
	 */
	public Vector<EndPoint> real;

	/**
	 * protocol module name
	 */
	public String protomod = "";

	/**
	 * protocol module option strings
	 */
	public String option = "";

	/**
	 * protocol module reschedule flag
	 */
	public boolean reschedule;

	/**
	 * scheduler name
	 */
	public String sched = "";

	/**
	 * max connection setting
	 */
	public int maxconn;

	/**
	 * QoS limit per virtual service
	 */
	public long qosservice;

	/**
	 * QoS limit per client
	 */
	public long qosclient;

	/**
	 * current throughput
	 */
	public long throughput;

	/**
	 * sorry server
	 */
	public EndPoint sorryserver;

	/**
	 * sorry flag
	 */
	public boolean sorryflag;

	/**
	 * timeout of real server monitor
	 */
	public int timeout;

	/**
	 * check count of real server monitor
	 */
	public int checkcount;

	/**
	 * connection type of real server monitor
	 */
	public String checktype = "";

	/**
	 * service type of real server monitor
	 */
	public String service = "";

	/**
	 * quiescent flag
	 */
	public String quiescent = "";

	/**
	 * check port of real server monitor
	 */
	public int checkport;

	/**
	 * request string of real server monitor
	 */
	public String request = "";

	/**
	 * response string of real server monitor
	 */
	public String receive = "";

	/**
	 * HTTP method of real server monitor
	 */
	public String httpmethod = "";

	/**
	 * HTTP virtual host of real server monitor
	 */
	public String virtualhost = "";

	/**
	 * login user name for real server monitor
	 */
	public String login = "";

	/**
	 * password for real server monitor
	 */
	public String passwd = "";

	/**
	 * database name for real server monitor
	 */
	public String database = "";

	/**
	 * protocol name
	 */
	public String protocol = "";
	
	/**
	 * real server down callback script file path
	 */
	public String downcallback = "";

	/**
	 * real server up callback script file path
	 */
	public String upcallback = "";

	/**
	 * virtual position in l7directord.cf
	 */
	int cfPosition = 0;

	/**
	 * 
	 * Constructor
	 * 
	 */
	public VirtualSetting() {
		this.virtual = new EndPoint();
		this.real = new Vector<EndPoint>();
		this.sorryserver = new EndPoint();
	}

	/**
	 * 
	 * Copy Constructor
	 * 
	 * @param v
	 */
	public VirtualSetting(VirtualSetting v) {
		this.virtual = new EndPoint(v.virtual);
		this.real = (Vector<EndPoint>) v.real.clone();
		this.protomod = new String(v.protomod);
		this.option = new String(v.option);
		this.sched = new String(v.sched);
		this.maxconn = v.maxconn;
		this.qosservice = v.qosservice;
		this.qosclient = v.qosclient;
		this.sorryserver = new EndPoint(v.sorryserver);
		this.sorryflag = v.sorryflag;
		this.timeout = v.timeout;
		this.checkcount = v.checkcount;
		this.checktype = new String(v.checktype);
		this.service = new String(v.service);
		this.quiescent = new String(v.quiescent);
		this.checkport = v.checkport;
		this.request = new String(v.request);
		this.receive = new String(v.receive);
		this.httpmethod = new String(v.httpmethod);
		this.virtualhost = new String(v.virtualhost);
		this.login = new String(v.login);
		this.passwd = new String(v.passwd);
		this.database = new String(v.database);
		this.protocol = new String(v.protocol);
		this.downcallback = new String(v.downcallback);
		this.upcallback = new String(v.upcallback);
	}

	/**
	 * 
	 * <p>
	 * complementOption method
	 * </p>
	 * 
	 * @param vs
	 * @return
	 */
	public void complementOption() {
		String fullOption = "";
		if (this.protomod == null || this.option == null)
			return;
		if (this.protomod.equals("cinsert")) {
			Pattern p = Pattern.compile("(?:--cookie-name|-C)\\s+([^\\s]+)");
			Matcher m = p.matcher(this.option);
			if (m.find())
				fullOption = "--cookie-name " + m.group(1);
			else {
				fullOption = "--cookie-name CookieName";
			}
			p = Pattern.compile("(?:--cookie-expire|-E)\\s+(\\d+)");
			m = p.matcher(this.option);
			if (m.find())
				fullOption += " --cookie-expire " + m.group(1);
			else {
				fullOption += " --cookie-expire 86400";
			}
			p = Pattern.compile("(?:--forwarded-for|-F)");
			m = p.matcher(this.option);
			if (m.find())
				fullOption += " --forwarded-for";
			p = Pattern.compile("(?:--reschedule|-R)");
			m = p.matcher(this.option);
			if (m.find())
				fullOption += " --reschedule";
			p = Pattern.compile("(?:--no-reschedule|-N)");
			m = p.matcher(this.option);
			if (m.find())
				fullOption += " --no-reschedule";
		}
		else if (this.protomod.equals("url")) {
			Pattern p = Pattern.compile("(?:--pattern-match|-P)\\s+([^\\s]+)");
			Matcher m = p.matcher(this.option);
			if (m.find())
				fullOption = "--pattern-match " + m.group(1);
			p = Pattern.compile("(?:--forwarded-for|-F)");
			m = p.matcher(this.option);
			if (m.find())
				fullOption += " --forwarded-for";
		}
		else if (this.protomod.equals("sessionless")) {
			Pattern p = Pattern.compile("(?:--forwarded-for|-F)");
			Matcher m = p.matcher(this.option);
			if (m.find())
				fullOption += "--forwarded-for";
		}
		else if (this.protomod.equals("sslid")) {
			Pattern p = Pattern.compile("(?:--timeout|-T)\\s+(\\d+)");
			Matcher m = p.matcher(this.option);
			if (m.find())
				fullOption += "--timeout " + m.group(1);
			else {
				fullOption += "--timeout 3600";
			}
			p = Pattern.compile("(?:--maxlist|-M)\\s+(\\d+)");
			m = p.matcher(this.option);
			if (m.find())
				fullOption += " --maxlist " + m.group(1);
			else {
				fullOption += " --maxlist 1024";
			}
			p = Pattern.compile("(?:--reschedule|-R)");
			m = p.matcher(this.option);
			if (m.find())
				fullOption += " --reschedule";
			p = Pattern.compile("(?:--no-reschedule|-N)");
			m = p.matcher(this.option);
			if (m.find())
				fullOption += " --no-reschedule";
		}
		this.option = fullOption;
	}

	/**
	 * 
	 * <p>
	 * isSameService method
	 * </p>
	 * 
	 * @param vs
	 * @return
	 */
	public boolean isSameService(VirtualSetting vs) {
		if (this.virtual.equals(vs.virtual) && this.isSameKey(vs)) {
			return true;
		}
		return false;
	}

	/**
	 * 
	 * <p>
	 * isSameKey method
	 * </p>
	 * 
	 * @param vs
	 * @return
	 */
	public boolean isSameKey(VirtualSetting vs) {
		if (this.protomod.equals(vs.protomod)) {
			String key1 = this.getKey();
			String key2 = vs.getKey();
			if (key1 != null && key2 != null && key1.equals(key2))
				return true;
		}
		return false;
	}

	/**
	 * 
	 * <p>
	 * getKey method
	 * </p>
	 * 
	 * @return
	 */
	public String getKey() {
		if (this.protomod == null || this.option == null)
			return null;
		this.complementOption();
		if (this.protomod.equals("cinsert")) {
			Pattern p = Pattern.compile("--cookie-name\\s+([^\\s]+)");
			Matcher m = p.matcher(this.option);
			if (m.find())
				return m.group(1).replaceAll("['\"]", "");
			else 
				return null;
		}
		if (this.protomod.equals("url")) {
			Pattern p = Pattern.compile("--pattern-match\\s+([^\\s]+)");
			Matcher m = p.matcher(this.option);
			if (m.find())
				return m.group(1).replaceAll("['\"]", "");
			else
				return null;
		}
		if (this.protomod.equals("sslid"))
			return "";
		if (this.protomod.equals("sessionless"))
			return "";
		
		return null;
	}

	/**
	 * 
	 * <p>
	 * equals method
	 * </p>
	 * 
	 * @param vs
	 * @return
	 */
	public boolean equals(VirtualSetting vs) {
		this.complementOption();
		vs.complementOption();
		if (this.virtual.equals(vs.virtual)
				&& this.protomod.equals(vs.protomod)
				&& this.option.equals(vs.option)
				&& this.sched.equals(vs.sched)
				&& this.maxconn == vs.maxconn
				&& this.qosservice == vs.qosservice
				&& this.qosclient == vs.qosclient
				&& this.sorryserver.equals(vs.sorryserver)
				&& this.sorryflag == vs.sorryflag
				&& this.timeout == vs.timeout
				&& this.checkcount == vs.checkcount
				&& this.checktype.equals(vs.checktype)
				&& this.service.equals(vs.service)
				&& this.quiescent == vs.quiescent
				&& this.checkport == vs.checkport
				&& this.request.equals(vs.request)
				&& this.receive.equals(vs.receive)
				&& this.httpmethod.equals(vs.httpmethod)
				&& this.virtualhost.equals(vs.virtualhost)
				&& this.login.equals(vs.login) && this.passwd.equals(vs.passwd)
				&& this.database.equals(vs.database)
				&& this.protocol.equals(vs.protocol)
				&& this.downcallback.equals(vs.downcallback)
				&& this.upcallback.equals(vs.upcallback)) {
			if (this.real == null && vs.real == null)
				return true;
			if (this.real.size() == vs.real.size()) {
				int sameCount = 0;
				for (EndPoint e1: this.real) {
					for (EndPoint e2: vs.real) {
						if (e1.equals(e2)) {
							sameCount++;
						}
					}
				}
				if (sameCount == this.real.size())
					return true;
			}
		}
		return false;
	}

    /**
     * 
     * <p>
     * equalsAdm method
     * </p>
     * 
     * @param vs
     * @return
     */
	public boolean equalsAdm(VirtualSetting vs) {
		this.complementOption();
		vs.complementOption();
		if (this.virtual.equals(vs.virtual)
				&& this.protomod.equals(vs.protomod)
				&& this.option.equals(vs.option) && this.sched.equals(vs.sched)
				&& this.maxconn == vs.maxconn
				&& this.qosservice == vs.qosservice
				&& this.qosclient == vs.qosclient
				&& this.sorryserver.equals(vs.sorryserver)) {
			if (this.real == null && vs.real == null)
				return true;
			if (this.real.size() == vs.real.size()) {
				int sameCount = 0;
				for (EndPoint e1: this.real) {
					for (EndPoint e2: vs.real) {
						if (e1.equals(e2)) {
							sameCount++;
						}
					}
				}
				if (sameCount == this.real.size())
					return true;
			}
		}
		return false;
	}

	/**
	 * 
	 * {@inheritDoc}
	 */
	public String toString() {
		return 
			"virtual=(" + this.virtual + "), " + 
			"real=(" + this.real + "), " +
			"protomod=\"" +  this.protomod + "\", " +
			"option=\"" + this.option + "\", " +
			"sched=\"" + this.sched + "\", " +
			"maxconn=" + this.maxconn + ", " +
			"qosservice=" + this.qosservice + ", " +
			"qosclient=" + this.qosclient + ", " +
			"sorryserver=(" + this.sorryserver + "), " +
			"sorryflag=" + this.sorryflag + ", " + 
			"timeout=" + this.timeout + ", " +
			"checkcount=" + this.checkcount + ", " +
			"checktype=\"" + this.checktype + "\", " +
			"service=\"" + this.service + "\", " +
			"quiescent=\"" + this.quiescent + "\", " +
			"checkport=\"" + this.checkport + "\", " +
			"request=\"" + this.request + "\", " +
			"receive=\"" + this.receive + "\", " +
			"httpmethod=\"" + this.httpmethod + "\", " +
			"virtualhost=\"" + this.virtualhost + "\", " +
			"login=\"" + this.login + "\", " +
			"passwd=\"" + this.passwd + "\", " +
			"database=\"" + this.database + "\", " +
			"protocol=\"" + this.protocol + "\", " +
			"downcallback=\"" + this.downcallback + "\", " +
			"upcallback=\"" + this.upcallback + "\"";
	}
}
