package org.ultramonkey.l7.controller;
import java.io.Serializable;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * <p>class ClusterData</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author nakai
 */
public class ClusterData implements Serializable {
    static final long serialVersionUID = 1;

    /**
     * cluster status (self node)
     */
    public ClusterStatus self_status;
    
    /**
     * cluster status (other node)
     */
    public ClusterStatus other_status;
    
    /**
     * self IP address
     */
    public String self_ip;
    
    /**
     * self Hostname
     */
    public String self_hostname;
    
    /**
     * other IP address
     */
    public String other_ip;
    
    /**
     * other Hostname
     */
    public String other_hostname;

    public String logFileName;
    
    /**
     * 
     * Constructor
     *
     */
    public ClusterData() {
        // --- debug log (constructor) ---
    	Logger redundantLogger = Logger.getLogger(LogCategorySet.GUI_REDUNDANT);
    	if (redundantLogger.isDebugEnabled()) {
            redundantLogger.debug("11557 class ClusterData created.");
        }
        // --- debug log (constructor) ---

       this.self_status  = ClusterStatus.NONE;
    	this.other_status = ClusterStatus.NONE;
    	this.self_ip = null;
    	this.self_hostname = null;
    	this.other_ip = null;
    	this.other_hostname = null;
    	this.logFileName = null;
    }

    /**
     * 
     * {@inheritDoc}
     */
    public String toString() {
    	return
			"self_status=" + this.self_status + ", " +
			"self_ip=\"" + this.self_ip + "\", " +
			"self_hostname=\"" + this.self_hostname + "\", " +
			"other_status=" + this.other_status + ", " +
			"other_ip=\"" + this.other_ip + "\", " +
			"other_hostname=\"" + this.other_hostname + "\", " +
			"logFileName=\"" + this.logFileName + "\"";
    }
}
