<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*, java.util.*,
				 java.text.SimpleDateFormat,java.text.NumberFormat"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
    /*
     * check session
     */
    L7guiServletBase base = new L7guiServletBase();
    if (session.isNew() || base.checkSession(session) == false) {
        MessageView error = new MessageView(41277, LogCategorySet.GUI_USER_AUTHENTICATION, Message.INVALID_SESSSION); 
        session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
        response.sendRedirect(RedirectPages.LOGIN);
        return;
    }
    
    /*
     * get result message
     */
    MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
    String errorMessage = "";
    int errorNumber = 0;
    String category = "";
    String resultJudge = "success";
    if (message != null) {
      errorMessage = message.getMessage();
      errorNumber = message.getErrno();
      category = message.getCategory();
      session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
      if ( errorNumber >= ErrNo.ERRORNUMBER )
    	  resultJudge = "error";
    }
    
    /*
     * get command message
     */
    MessageView commandmessage = (MessageView) session.getAttribute(SessionKeys.COMMAND_MESSAGE);
    String commandMessage = "";
    int commandNumber = 0;
    String commandCategory = "";
    String commandJudge = "success";
    if (commandmessage != null) {
      commandMessage = commandmessage.getMessage();
      commandNumber = commandmessage.getErrno();
      commandCategory = commandmessage.getCategory();
      session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
      if ( commandNumber >= ErrNo.ERRORNUMBER )
    	  commandJudge = "error";
    }
 
    /*
     * get lb_log info
     */
     L7guiFramework framework = new L7guiFramework();
     LogData logdata = framework.getLogData();
     if (logdata == null){
         MessageView error = new MessageView(41278, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
         return;
     }
     
     LogSet lbdata = logdata.lbLog;
     if (lbdata == null){
         MessageView error = new MessageView(41279, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
         return;
     }     
     
     Vector<LogFileData> lblogfiles = lbdata.logFiles;
     if (lblogfiles == null){
         MessageView error = new MessageView(41280, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
         return;
     }
     
     HashMap<LogData.LogCategory, LogData.LogLevel> lblogcategoryset = lbdata.logLevel;
     if (lblogcategoryset == null){
         MessageView error = new MessageView(41281, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
         return;
     }
     
    /*
     * get cluster status
     */
    ClusterData cd = framework.getClusterData();
    if (cd == null){
        MessageView error = new MessageView(41282, LogCategorySet.GUI_IO_COMMAND, Message.CLUSTER_DATA_ERROR);
        session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
        response.sendRedirect(RedirectPages.LOGIN);
    }
     
  	/*
  	 * fix style seat
  	 */
  	String cssSeat = "l7gui_single_style.css";
  	if ( cd.self_status == ClusterStatus.ACTIVE ){
  		cssSeat = "l7gui_act_style.css";
  	}
  	else if ( cd.self_status == ClusterStatus.STANDBY ){
  		cssSeat = "l7gui_sby_style.css";
  	}
 %>

 
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
<head>
  	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
   	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 		
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<script src="l7gui.js" type="text/javascript"></script>
  	<noscript> 
    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
  	</noscript> 
	  <link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
	  <link rel="shortcut icon" href="images/favicon.ico"/>
	  <title>Log - Load balancer (l7vsd) -</title>
</head>

<body class="normal">
  <jsp:include page="menu.jsp" flush="false"/>
  <div id="content">

  <h1>Log - Load balancer (l7vsd) -</h1>
  <%
  if ( (message != null ) && (errorMessage != null) ) {
  %>
  
  <p class="<%=resultJudge %>">[<%=category%>-<%=errorNumber%>]</p>
  <p class="<%=resultJudge %>"><%=errorMessage%></p>
  
  <%
  } else if ( (commandmessage != null) && (commandMessage != null) ) {
  %>
  <p class="<%=commandJudge %>">[<%=commandCategory%>-<%=commandNumber%>]</p>
  <p class="<%=commandJudge %>"><%=commandMessage%></p>
  <%
  }
  %>
      
  <h2>Download Log file</h2>
  <h4>Please select the following log file you would like to download.</h4>

  <table  class="infotable" cellspacing="0">
  <tr>
    <th>LogFileName</th><th>LastUpdate</th><th>FileSize(byte)</th>
  </tr>
<%
	SimpleDateFormat dfm = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
	NumberFormat num = NumberFormat.getInstance();
	Iterator<LogFileData> i = lblogfiles.iterator();

    while ( i.hasNext() ){
    	LogFileData log = (LogFileData) i.next();
        if ( log != null && log.fileName != null){
 	        out.println("<tr>");
            out.println("<td>");
            out.println("<a href=\"LogOutputServlet?type=" + LogCategorySet.L7VSD + "&log=" + log.fileName + "\">" + log.fileName + "</a>");
            out.println("</td>");
            out.println("<td class=\"center\">" + dfm.format(log.time) + "</td>");            
            out.println("<td class=\"right\">" + num.format(log.size) + "</td>");               
            out.println("</tr>");
        }
    }
%>
  </table>
    
  <br />
    
  <h2>Change Log Level</h2>
  <h4>Please select log level of you would like to change.</h4>
    
  <form method="post" action="LogLevelServlet" name="log_lb">
  <input type="hidden" name="type" value="<%=LogCategorySet.L7VSD %>">
  <table  class="infotable" cellspacing="0">  
    <tr>
      <th>Category</th><th>Level</th>
    </tr>
      <%
	    TreeSet<LogData.LogCategory> tree = new TreeSet<LogData.LogCategory>(lblogcategoryset.keySet());
	    Iterator<LogData.LogCategory> it = tree.iterator();
          while (it.hasNext()) {
      	    LogData.LogCategory logcategory = (LogData.LogCategory) it.next();
      	    if (logcategory != null){
      %>
    <tr>
    <td><%= logcategory %></td>
    <td>
    <select id="<%= logcategory %>" name="<%= logcategory %>">
      <option value="<%=LogData.LogLevel.NONE %>"<%
                if ( lblogcategoryset.get(logcategory) == LogData.LogLevel.NONE)
                        out.print(" selected");
                %>></option>
      <option value="<%=LogData.LogLevel.DEBUG %>"<%
                 if ( lblogcategoryset.get(logcategory) == (LogData.LogLevel.DEBUG)) {
                     out.print(" selected");
                 }
                %>>DEBUG</option>
      <option value="<%=LogData.LogLevel.INFO %>"<%
                if ( lblogcategoryset.get(logcategory) == (LogData.LogLevel.INFO)){ 
                  out.print(" selected");
                }
                %>>INFO</option>
      <option value="<%=LogData.LogLevel.ERROR %>"<%
                if (lblogcategoryset.get(logcategory) == (LogData.LogLevel.ERROR)){
                    out.print(" selected");
                }
                %>>ERROR</option>          
      <option value="<%=LogData.LogLevel.WARN %>"<%
                if ( lblogcategoryset.get(logcategory) == (LogData.LogLevel.WARN)){ 
                  out.print(" selected");
                }
                %>>WARN</option>
      <option value="<%=LogData.LogLevel.FATAL %>"<%
                if ( lblogcategoryset.get(logcategory) == (LogData.LogLevel.FATAL)){ 
                  out.print(" selected");
                }
                %>>FATAL</option>
    </select>
    </td>
    </tr>
          <%
          }
      }
      %>
      </table>
      
      <br>
      <input type="submit" name="button" value="<%= ButtonMode.APPLY %>" onClick="return confirm(log_lb_apply)" />


      <input type="submit" name="button" value="<%= ButtonMode.SAVE %>" onClick="return confirm(log_lb_save)" />  
      <%
          if (cd.self_status == ClusterStatus.ACTIVE || cd.self_status == ClusterStatus.STANDBY) {
      %>
      <input type="submit" name="button" value="<%= ButtonMode.SAVESYNC %>" onClick="return confirm(log_lb_savesync)" />
      <%
          }
      %>    
    </form>
  
  </div>
  </body>
</html>