package org.ultramonkey.l7.controller;

import java.io.Serializable;
import java.util.HashMap;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>class ReplicationData</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class ReplicationData implements Serializable {
    static final long serialVersionUID = 1L;

    /**
     * Replication Status (MASTER, MASTER_STOP, SLAVE, SLAVE_STOP, SINGLE, OUT)
     */
    public ReplicationStatus replicationMode;
    
    /**
     * Network Interface name of using for replication
     */
	public String nic;
	
	/**
	 * IP address and port number of the other node
	 */
	public EndPoint otherNode;
	
	/**
	 * Replication interval seconds
	 */
	public int interval;

	/**
	 * Replication component setting
	 */
	public HashMap<String, Integer> component;
	
	/**
	 * 
	 * Constructor
	 *
	 */
	public ReplicationData() {
        // --- debug log (constructor) ---
	    Logger repLogger = Logger.getLogger(LogCategorySet.GUI_REPLICATION);
        if (repLogger.isDebugEnabled()) {
            repLogger.debug("11508 class ReplicationData created.");
        }
        // --- debug log (constructor) ---

		this.replicationMode = ReplicationStatus.MASTER_STOP;
		this.nic = "";
		this.otherNode = new EndPoint();
		this.interval = 0;
		this.component = new HashMap<String, Integer>();
	}
	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public String toString() {
		return
			"replicationMode=" + this.replicationMode + ", " +
			"nic=\"" + this.nic + "\", " +
			"otherNode=(" + this.otherNode + "), " +
			"interval=" + this.interval + ", " +
			"component=(" + this.component + ")";
	}
}
