package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.*;

/**
 * Servlet implementation class for Servlet: ReplicationModeChangeServlet
 *
 */

public class ReplicationModeChangeServlet extends L7guiServletBase {
	static final long serialVersionUID = 1L;	
	
	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public ReplicationModeChangeServlet() {
		super();
        // --- debug log (constructor) ---
        if (logger.isDebugEnabled()) {
            logger.debug("11389 class ReplicationModeChangeServlet created.");
        }
        // --- debug log (constructor) ---
	}

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("ReplicationModeChangeServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11390 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11391 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11392 ReplicationModeChangeServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}  	
	
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("ReplicationModeChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11393 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11394 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);
		
		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41174, LogCategorySet.GUI_USER_AUTHENTICATION,
					Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11395 ReplicationModeChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		ExecuteMode mode;
        request.setCharacterEncoding("UTF-8");
		String buttonMode = request.getParameter("button");
		if (buttonMode == null){
			MessageView error = new MessageView(41175, LogCategorySet.GUI_REPLICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11396 ReplicationModeChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		if (buttonMode.equals(ButtonMode.REP_MASTER_RUNNING))
			mode = ExecuteMode.REP_MASTER;
		else if (buttonMode.equals(ButtonMode.REP_MASTER_STOPPING))
			mode = ExecuteMode.REP_MASTER_STOP;
		else if (buttonMode.equals(ButtonMode.REP_SLAVE_RUNNING))
			mode = ExecuteMode.REP_SLAVE;
		else if (buttonMode.equals(ButtonMode.REP_SLAVE_STOPPING))
			mode = ExecuteMode.REP_SLAVE_STOP;
		else{
			MessageView error = new MessageView(41176, LogCategorySet.GUI_REPLICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11397 ReplicationModeChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		CommandExecuter thread = new CommandExecuter(session);
		try {
			thread.setExecute(mode);
			thread.start();
		}
		catch(Exception e)	{
			MessageView error = new MessageView(41177, LogCategorySet.GUI_REPLICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11398 ReplicationModeChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		response.sendRedirect(RedirectPages.REPLICATION_MODE_EXECUTIVE);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11399 ReplicationModeChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}
}
