package org.ultramonkey.l7.model;

import org.apache.log4j.Logger;

/**
 * 
 * <p>class FileNotWriteException</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class FileNotWriteException extends Exception {
	static final long serialVersionUID = 1L;

	private Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);

	protected String fileName = "";

	protected int errno = 0;

	protected String errMessage = "";

	/**
	 * 
	 * Constructor
	 *
	 */
	public FileNotWriteException() {
        // --- debug log (constructor) ---
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11162 class FileNotWriteException created.");
        }
        // --- debug log (constructor) ---
	}

	/**
	 * 
	 * <p> getFileName method</p>
	 *
	 * @return
	 */
	public String getFileName() {
		// --- debug log (in/out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11163 FileNotWriteException::getFileName() in");
            ioFileLogger.debug("11164 FileNotWriteException::getFileName() out return=\"" + this.fileName + "\"");
		}
		// --- debug log (in/out method) ---
		return this.fileName;
	}

	/**
	 * 
	 * <p> setFileName method</p>
	 *
	 * @param fileName
	 */
	public void setFileName(String fileName) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11165 FileNotWriteException::setFileName(String fileName) in fileName=\"" + this.fileName + "\"");
		}
		// --- debug log (in method) ---

		this.fileName = fileName;

		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11166 FileNotWriteException::setFileName(String fileName) out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * 
	 * <p> getErrno method</p>
	 *
	 * @return
	 */
	public int getErrno() {
		// --- debug log (in/out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11167 FileNotWriteException::getErrno() in");
            ioFileLogger.debug("11168 FileNotWriteException::getErrno() out return=" + this.errno);
		}
		// --- debug log (in/out method) ---
		return this.errno;
	}

	/**
	 * 
	 * <p> setErrNo method</p>
	 *
	 * @param errno
	 */
	public void setErrNo(int errno) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11169 FileNotWriteException::setErrno(String errno) in errno=" + this.errno);
		}
		// --- debug log (in method) ---
		
		this.errno = errno;

		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11170 FileNotWriteException::setErrno(String errno) out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * 
	 * <p> getErrMessage method</p>
	 *
	 * @return
	 */
	public String getErrMessage() {
		// --- debug log (in/out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11171 FileNotWriteException::getErrMessage() in");
            ioFileLogger.debug("11172 FileNotWriteException::getErrMessage() out return=\"" + this.errMessage + "\"");
		}
		// --- debug log (in/out method) ---
		return errMessage;
	}

	/**
	 * 
	 * <p> setErrMessage method</p>
	 *
	 * @param errMessage
	 */
	public void setErrMessage(String errMessage) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11173 FileNotWriteException::setErrMessage(String errMessage) in errMessage=\"" + this.errMessage + "\"");
		}
		// --- debug log (in method) ---

		this.errMessage = errMessage;
		
		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
			ioFileLogger.debug("11174 FileNotWriteException::setErrMessage(String errMessage) out");
		}
		// --- debug log (out method) ---
	}
}
