<%@ page import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*,java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
	/*
	 * check session
	 */
	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41407, LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	

	/*
	 * get l7vsadm data from L7guiFramework
	 */
	L7guiFramework framework = new L7guiFramework();
	L7vsAdmData admDataList = framework.getAdmData();
	if (admDataList == null) {
		MessageView error = new MessageView(41408, LogCategorySet.GUI_VIRTUALSERVICE,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

		
	/*
	 * get l7directrod.cf data
	 */
	DirectorData dd = framework.getDirectorData();
	if (dd == null) {
		MessageView error = new MessageView(41409, LogCategorySet.GUI_IO_FILE,
		Message.DIRECTOR_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	/*
	 * get cluster status
	 */
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41410, LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
  		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%= cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico"/>

		<title>UltraMonkey-L7 Current Status</title>

	</head>
 
	<body class="normal">
		<div id="content">

		<h1>VirtualService Current Status</h1>
<%
	if ( (cd.self_status.equals(ClusterStatus.ACTIVE)) || (cd.self_status.equals(ClusterStatus.SINGLE) )){

		MessageView mv = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
			String message = null;
			int errno = 0;
			String category = null;
			
			if (mv != null) {
				message  = mv.getMessage();
				errno    = mv.getErrno();
				category = mv.getCategory();
				if ( message != null){
					out.println("<p class=\"error\">[" + category + "-" + errno + "] </p>" );
					out.println("<p class=\"error\">" + message + "</p>");
				}
				session.setAttribute(SessionKeys.RESULT_MESSAGE,null);
			}
		%>
		
		
		<%
			MessageView mvCommand = (MessageView) session.getAttribute(SessionKeys.COMMAND_MESSAGE);
			String commandMessage = null;
			int commandErrno = 0;
			String commandCategory = null;
			if (mvCommand != null) {
				commandMessage  = mvCommand.getMessage();
				commandErrno    = mvCommand.getErrno();
				commandCategory = mvCommand.getCategory();
				if ( commandMessage != null ){
					out.println("<p class=\"success\">[" + commandCategory + "-" + commandErrno + "] </p>" );
					out.println("<p class=\"success\">" + commandMessage + "</p>");
				}
				session.setAttribute(SessionKeys.COMMAND_MESSAGE,null);
			}
		%>
		
		<form method="post" action="VSRemoveServlet" name="vs_info" id="vs_info">
			<%
				/*
				 * get VirtualService data from L7guiFramework
				 */
				Vector<VirtualSetting> vsList = new Vector<VirtualSetting>();
				vsList = admDataList.virtualSettings;	
				ArrayList<String> vsNameList = new ArrayList<String>();	
				vsNameList.clear();
			
				String vsIp  = null;
				String vsPort = null;
				String vsProtomod = null;
				String vsOption = null;
				String vsSchedule = null;
				String rsIP = null;
				String rsPort = null;
				int rsWeight = 0;
				long activeConnections = 0;
				long inactiveConnections = 0;
				String vsSorryFlag = null;
				
				if (vsList.size() > 0) {
			%>
			<fieldset>
			<legend>Virtual Service List</legend>
				<table class="infotable" cellspacing="0">
				<tr>
					<th class="point" rowspan="2">
					<label for="Remove Modify Check">Remove/<br />Modify CHECK</label>				 
					</th>
					<th class="head" colspan="5">
					<label for="VirtualService">VirtualService</label>				 
					</th>
					<th class="head" colspan="5">
					<label for="RealServices">RealServer</label>
					</th>
					<th rowspan="2">
					<label for="SorryFlag">Sorry Flag</label>
					</th>					
				</tr>		
				<tr>
					<th>
					<label for="VirtualIP Address">VirtualIP Address</label>
					</th> 
					<th>
					<label for="Port Number">Port Number</label>			
					</th>
					<th>
					<label for="Persistence Type">Persistence Type</label>						
					</th>
					<th>
					<label for="Module option">Module Option</label>						
					</th>
					<th class="point">
					<label for="Scheduler Type">Scheduler Type</label>						
					</th>
					<th>
					<label for="RealServer IP Address">IP Address</label>						
					</th>
					<th>
					<label for="RealServer Port Number">Port Number</label>									
					</th>
					<th>
					<label for="RealServer weight">Weight</label>												
					</th>
					<th>
					<label for="ActiveConnections">Active Connections</label>												
					</th>
					<th class="point">
					<label for="InactiveConnections">Inactive Connections</label>												
					</th>					
				</tr>
			<% 
				for (int i = 0; i < vsList.size(); i++) { 		
					try {
						VirtualSetting getVirtualSetting = vsList.get(i);
				
						vsIp = getVirtualSetting.virtual.host;
						vsPort = getVirtualSetting.virtual.port;
						vsProtomod = getVirtualSetting.protomod;
						vsOption = getVirtualSetting.option;		
						vsSchedule = getVirtualSetting.sched;
				
						Vector<EndPoint> getRsList =getVirtualSetting.real; 
						int rsNumber = getRsList.size();
						if ( rsNumber < 0 ){
							rsNumber = 1;
						}
							
						boolean vsSorry = getVirtualSetting.sorryflag;
						
						if ( (vsIp == null) || (vsProtomod == null) || (vsOption == null) ){
							MessageView error = new MessageView(41411, LogCategorySet.GUI_VIRTUALSERVICE,
							Message.UNEXPECTED_ERROR);
							session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
							response.sendRedirect(RedirectPages.LOGIN);
							return;
						}
						vsNameList.add(vsIp + ":" + vsPort + ":" + vsProtomod + ":" + vsOption);
			%>
					
				<tr>	
					<td class="point" rowspan="<%=rsNumber %>"><input type="radio" name= "vs" value="<%=vsNameList.get(i) %>" /></td>
					<td class="center" rowspan="<%=rsNumber %>"><%=vsIp%></td>
					<td class="center" rowspan="<%=rsNumber %>"><%=vsPort%></td>
					<td class="center" rowspan="<%=rsNumber %>"><%=vsProtomod%></td>
					<td class="center" rowspan="<%=rsNumber %>"><%=vsOption%></td>
					<td class="point" rowspan="<%=rsNumber %>"><%=vsSchedule%></td>
				<%
						if ( rsNumber < 1 ){
				%>
						<td class="center">-</td>
						<td class="center">-</td>
						<td class="center">-</td>
						<td class="center">-</td>
						<td class="point">-</td>						
				<%
						}
						else{
							EndPoint getRs = getRsList.get(0);
							rsIP = getRs.host;
							rsPort = getRs.port;
							rsWeight = getRs.weight;
							activeConnections = getRs.actConn;
							inactiveConnections = getRs.inActConn;							
				%>
						<td class="center"><%=rsIP%></td>
						<td class="center"><%=rsPort%></td>
						<td class="center"><%=rsWeight%></td>
						<td class="center"><%=activeConnections%></td>
						<td class="point"><%=inactiveConnections%></td>												
				<%
						}
						if(vsSorry == true){
							vsSorryFlag = "On";
						}
						else {
							vsSorryFlag = "Off";
						}
				%>
				<td class="center" rowspan="<%=rsNumber %>"><%=vsSorryFlag %></td>
				</tr>
				<%
						for ( int j = 1; j < rsNumber; j++ ){ 
							EndPoint addedGetRs = getRsList.get(j);
							rsIP = addedGetRs.host;
							rsPort = addedGetRs.port;
							rsWeight = addedGetRs.weight;
							activeConnections = addedGetRs.actConn;
							inactiveConnections = addedGetRs.inActConn;							
				%>
				<tr>
						<td class="center"><%=rsIP%></td>
						<td class="center"><%=rsPort%></td>
						<td class="center"><%=rsWeight%></td>
						<td class="center"><%=activeConnections%></td>
						<td class="point"><%=inactiveConnections%></td>
				</tr>
				<%
						}
				%>
			
				<%		
						}catch(NullPointerException e){
							MessageView error = new MessageView(41412, LogCategorySet.GUI_VIRTUALSERVICE,
									Message.UNEXPECTED_ERROR);
							session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
							response.sendRedirect(RedirectPages.LOGIN);
							return;
						}
					}
				%>
				</table>
				</fieldset>
				<%
				}
				%>
		
			<h2>Add a New VirtualService</h2>
			<h4>Please push the following button, if you would like to add a new virtualService.</h4><br />
			
			<input type="button" value="<%= ButtonMode.ADD %>" onclick="location.href='<%=RedirectPages.VS_ADD %>'" />
		
			<%
			if (vsList.size() > 0) {
			%>
			<h2>Modify a VirtualService</h2>
			<h4>Please select and push the following button, if you would like to modify a virtualService.</h4><br />	
		
			<input type="button" value="<%= ButtonMode.MODIFY %>" onClick="vs_modify('<%=RedirectPages.VS_MODIFY %>')" />
		
			<h2>Remove a VirtualService</h2>
			<h4>Please select and push the following button, if you would like to remove a virtualService.</h4><br />	
			
			<input type="submit" name="button_remove" value="<%=ButtonMode.APPLY %>" onClick="return confirm(remove_vs_apply)" />
			<%
				if (dd.autoreload == true) {
			%>
			<input type="submit" name="button_remove" value="<%=ButtonMode.SAVE %>" onClick="return confirm(remove_vs_save)" />
			<%
					if (cd.self_status == ClusterStatus.ACTIVE || cd.self_status == ClusterStatus.STANDBY) {
			%>
			<input type="submit" name="button_remove" value="<%=ButtonMode.SAVESYNC %>" onClick="return confirm(remove_vs_savesync)" />
				<%
					}
				}
			}
			%>
			</form>

	<%
	}
	else{
		response.sendRedirect(RedirectPages.TOPMENU);
		return;

	}
	%>
</div>
<jsp:include page="menu.jsp" flush="false"/>
</body>
</html>

