<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	/*
	 * check session
	 */
    L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41384,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get VS IPaddress
	 */
	L7guiFramework framework = new L7guiFramework();
	ClusterData cd = framework.getClusterData();

	String self = "";
	String other = "";

	if (cd == null) {
		MessageView error = new MessageView(41385,
		LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute("resultMessage", error);
		response.sendRedirect("index.jsp");
		return;
	} else {
		self = cd.self_ip;
		other = cd.other_ip;
	}
	if ((self == null) || (other == null)) {
		MessageView error = new MessageView(41386,
		LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if (cd.self_status == ClusterStatus.ACTIVE) {
		cssSeat = "l7gui_act_style.css";
	} else if (cd.self_status == ClusterStatus.STANDBY) {
		cssSeat = "l7gui_sby_style.css";
	}
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<noscript>
	<meta http-equiv="refresh"
		content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
	</noscript>
	<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
	<link rel="shortcut icon" href="images/favicon.ico" />
	<title>Succeeded : Switch-Over</title>
</head>

<body class="normal">

<jsp:include page="menu.jsp" flush="false" />

<div id="content">
<h1 class="title">Succeeded : Switch-Over</h1>
<fieldset class="">
<legend>Current Status</legend>
<table class="infotable">
<tr>
	<th class="center">
	<label for="empty"></label>
	</th>
	<th class="center">
	Self Node
	</th>
	<th class="center">
	Peer Node
	</th>
</tr>
<tr>
	<th class="left">
	<label for="nodeStatus">Node Status</label>
	</th>
	<td>
	<%= cd.self_status %>
	</td>
	<td>
	<%= cd.other_status %>
	</td>
</tr>					
<tr>
	<th class="left">
	<label for="realIp">Real IP Address</label>
	</th>
	<td>
	<%= cd.self_ip %>
	</td>
	<td>
	<%= cd.other_ip %>
	</td>
</tr>
</table>
</fieldset>
</div>
</body>
</html>
