/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.log4j.helpers.LogLog;

public class PropertyGetter {
    protected static final Object[] NULL_ARG = new Object[0];
    protected Object obj;
    protected PropertyDescriptor[] props;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PropertyGetter(Object obj) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(obj.getClass());
        this.props = bi.getPropertyDescriptors();
        this.obj = obj;
    }

    public static void getProperties(Object obj, PropertyCallback callback, String prefix) {
        try {
            new PropertyGetter(obj).getProperties(callback, prefix);
        }
        catch (IntrospectionException ex) {
            LogLog.error("Failed to introspect object " + obj, ex);
        }
    }

    public void getProperties(PropertyCallback callback, String prefix) {
        int i = 0;
        while (i < this.props.length) {
            Method getter = this.props[i].getReadMethod();
            if (getter != null && this.isHandledType(getter.getReturnType())) {
                String name = this.props[i].getName();
                try {
                    Object result = getter.invoke(this.obj, NULL_ARG);
                    if (result != null) {
                        callback.foundProperty(this.obj, prefix, name, result);
                    }
                }
                catch (Exception exception) {
                    LogLog.warn("Failed to get value of property " + name);
                }
            }
            ++i;
        }
    }

    protected boolean isHandledType(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(clazz.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type))) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.apache.log4j.Priority");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isAssignableFrom(type)) {
                return false;
            }
        }
        return true;
    }

    public static interface PropertyCallback {
        public void foundProperty(Object var1, String var2, String var3, Object var4);
    }
}

