<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*, java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
	
<%
	/*
	 * check session
	 */
	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41436, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}


	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = "";
	int errorNumber = 0;
	String  category = "";
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}
	
	/*
	 * get validation error message
	 */
	HashMap<String,String> errMessage = (HashMap<String,String>) session.getAttribute(SessionKeys.INVALID_MESSAGE);
	session.setAttribute(SessionKeys.INVALID_MESSAGE,null);
	
	/*
	 * get previous input value
	 */
	L7guiFramework framework = new L7guiFramework();
	VirtualSetting vs = (VirtualSetting) session.getAttribute(SessionKeys.INPUT_VS);
	if (vs != null) {
		session.setAttribute(SessionKeys.INPUT_VS, null);
	}

	/*
	 * get l7directrod.cf data
	 */
	DirectorData dd = framework.getDirectorData();
	if (dd == null) {
		MessageView error = new MessageView(41437, LogCategorySet.GUI_IO_FILE,
				Message.DIRECTOR_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
		

	/*
	 * get cluster status
	 */
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41438, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

%>	



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
	 	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	 	<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
			<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico" />
	
		<title>Add VirtualService</title>
	</head>

	<body class="normal">
		<jsp:include page="menu.jsp" flush="false"/>
		<div id="content">
			<h1 class="title">Add a VirtualService</h1>						
<%
if ( (cd.self_status.equals(ClusterStatus.ACTIVE)) || (cd.self_status.equals(ClusterStatus.SINGLE) )){

	if ( (message != null) && (errorMessage != null)) {
%>

<p class="error">[<%=category %> - <%=errorNumber %>]</p>
<p class="error"><%=errorMessage %></p>

<%
	}
%>		

			<h2> VirtualService Info</h2>
			<form method="post" action="VSAddServlet" name="vs_add">


			<fieldset>
				<legend>Basic Settings</legend>
			
				<table class="status">
				<tr>
					<th>
						<label for="ip">Virtual IP address</label>
					</th>
					<td>
						<input type="text" id="ip" name="vip" value="<%
						if ( null != vs ) 
									out.println(vs.virtual.host); %>" maxlength="15" />
						<% 
							if ( null != errMessage ){
								String invalidMessage = errMessage.get("vip");
								if( null != invalidMessage ){
									out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
								}
							}
						%>
					</td>
					<td>
						<p class="item">Required Field</p>
						<p class="required">[0-255].[0-255].[0-255].[0-255]</p>
					</td>
				</tr>
				<tr>
					<th>
						<label for="port">Port Number</label>
					</th>
					<td>
						<%
						{
							String invalidMessage = null;
							if ( null != errMessage ) {
								invalidMessage = errMessage.get("port");
							}

							if ( (vs == null) || (vs.virtual.port == null) ){

								out.println("<input type=\"text\" id=\"port\" value=\"\" name=\"port\" />");
							}											
							else{
								out.println("<input type=\"text\" id=\"port\" value=\"" + vs.virtual.port + "\"name=\"port\" />");
							}																
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
						%>
					</td>
					<td>
						<p class="item">Required Field</p>
						<p class="required">1-65535, service name</p>
					</td>
				</tr>
				<tr>
					<th>
						<label for="protomod">Persistence Type</label>
					</th>
					<td>
						<select id="protomod" name="protomod">
							<option value="cinsert"<%
							if ( (vs != null ) && (vs.protomod.equals("cinsert")) )
								out.print(" selected");
							%>>Cookie Insert</option>
							<option value="url"<%
							if ( (vs != null ) && (vs.protomod.equals("url")) )
								out.print(" selected");
							%>>URL Pattern</option>
							<option value="sslid"<%
							if ( (vs != null ) && (vs.protomod.equals("sslid")) )
								out.print(" selected");
							%>>SSL Session ID</option>
							<option value="sessionless"<%
							if ( (vs != null ) &&  (vs.protomod.equals("sessionless")) )
								out.print(" selected");
							%>>Sessionless</option>
						</select>
						<% 
							if ( null != errMessage ){
								String invalidMessage = errMessage.get("protomod");
								if( null != invalidMessage ){
									out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
								}
							}
						%>
					</td>
					<td>
						<p class="item">Required Field</p>
					</td>
				</tr>
				<tr>
					<th>
						<label for="option">Persistence option</label>
					</th>
					<td>
						<input type="text" id="option" name="option" value="<% 
							if ( null != vs ) 
									out.println(vs.option); %>" maxlength="127" />
						<% 
							if ( null != errMessage ){
								String invalidMessage = errMessage.get("option");
								if( null != invalidMessage ){
									out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
								}
							}
						%>
					</td>
					<td>
						<p class="required">Up to 127 one-byte characters in English</p>
					</td>
				</tr>
				<tr>
					<th>
						<label for="sched">Scheduler Type</label>
					</th>
					<td>
						<select id="sched" name="sched">
							<option value="rr"<%
							if ( (vs != null ) && (vs.sched.equals("rr")) )
								out.print(" selected");
							%>>Round Robin</option>
							<option value="wrr"<%
							if ( (vs != null ) && (vs.sched.equals("wrr")) )
								out.print(" selected");
							%>>Weighted Round Robin</option>
							<option value="lc"<%
							if ( (vs != null ) && (vs.sched.equals("lc")) )
								out.print(" selected");
							%>>Least Connection</option>
						</select>
						<% 
							if ( null != errMessage ){
								String invalidMessage = errMessage.get("sched");
								if( null != invalidMessage ){
									out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
								}
							}
						%>
					</td>
					<td>
						<p class="required"></p>
					</td>
				</tr>
				</table>
			</fieldset>
			<fieldset class="">
			<legend>Advanced Settings</legend>
				<table class="status">
				<tr>
					<th>
						<label for="qos_srv">QoS (per Virtual Service)</label>
					</th>
					<td>
						<%	{
							String invalidMessage = null;
							int unit_s = 0;
							if ( null != errMessage ) {
								invalidMessage = errMessage.get("qos_service");
							}
							if ( (vs == null) || ( ( 0 == vs.qosservice ) && ( null != invalidMessage ) ) ){
								out.println("<input type=\"text\" id=\"qos_srv\" value=\"\" name=\"qos_service\" size=\"3\" maxlength=\"3\" />");
							}											
							else{
								if ( null == invalidMessage ){ 
									while ( (vs != null) && (vs.qosservice >= 1000) ) {
										vs.qosservice /= 1000;
										unit_s++;
									}
								}
								out.println("<input type=\"text\" id=\"qos_srv\" value=\"" + vs.qosservice + "\"name=\"qos_service\" size=\"3\" maxlength=\"3\" />");
							}
						%>
						<select id="qos_srv" name="qos_service_unit">
							<option value="bps"<%
								if ( (vs != null) && (unit_s == 0) )
									out.print(" selected");
							%>>bps</option>
							<option value="Kbps"<%
								if ( (vs != null) && (unit_s == 1) )
									out.print(" selected");
							%>>Kbps</option>
							<option value="Mbps"<%
								if ( (vs != null) && (unit_s == 2) )
									out.print(" selected");
							%>>Mbps</option>
							<option value="Gbps"<%
								if ( (vs != null) && (unit_s == 3) )
									out.print(" selected");
							%>>Gbps</option>
						</select>
						<% 
								if( null != invalidMessage ){
									out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
								}
							}
						%>				
					</td>
					<td>
						<p class="required">0-999(bps/Kbps/Mbps/Gbps)</p>
					</td>
				</tr>
				<tr>
					<th>
						<label for="qos_conn">QoS (per Client)</label>
					</th>
					<td>
						<%	{
							String invalidMessage = null;
							int unit_c = 0;
							if ( null != errMessage ) {
								invalidMessage = errMessage.get("qos_conn");
							}								
							if ( (vs == null) || ( ( 0 == vs.qosclient ) && ( null != invalidMessage ) ) ){
								out.print("<input type=\"text\" id=\"qos_conn\" value=\"\" name=\"qos_conn\" size=\"3\" maxlength=\"3\" />");
							}											
							else{
								if ( null == invalidMessage ){
									while ( (vs != null) &&  (vs.qosclient >= 1000) ) {
										vs.qosclient /= 1000;
										unit_c++;
									}
								}
								out.print("<input type=\"text\" id=\"qos_conn\" value=\"" + vs.qosclient + "\" name=\"qos_conn\" size=\"3\" maxlength=\"3\" />");
							}
						%>
						<select id="qos_conn" name="qos_conn_unit">
							<option value="bps"<%
								if ( (vs != null) && (unit_c == 0) )
									out.print(" selected");
							%>>bps</option>
							<option value="Kbps"<%
								if ( (vs != null) && (unit_c == 1) )
									out.print(" selected");
							%>>Kbps</option>
							<option value="Mbps"<%
								if ( (vs != null) && (unit_c == 2) )
									out.print(" selected");
							%>>Mbps</option>
							<option value="Gbps"<%
								if ( (vs != null) && (unit_c == 3) )
									out.print(" selected");
							%>>Gbps</option>
						</select>
						<% 
								if( null != invalidMessage ){
									out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
								}
							}
						%>
					</td>
					<td>
						<p class="required">0-999(bps/Kbps/Mbps/Gbps)</p>
					</td>
				</tr>
				<tr>
					<th>
						<label for="max_conn">Max Connections</label>
					</th>
					<td>
						<%
						{
							String invalidMessage = null;
							if ( null != errMessage ) {
								invalidMessage = errMessage.get("max_conn");
							}
							if ( (vs == null) || ( ( 0 == vs.maxconn ) && ( null != invalidMessage ) ) ){
								out.println("<input type=\"text\" id=\"max_conn\" value=\"\" name=\"max_conn\" maxlength=\"6\" />");
							}											
							else{
								out.println("<input type=\"text\" id=\"max_conn\" value=\"" + vs.maxconn + "\" name=\"max_conn\" maxlength=\"6\" />");
							}
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
						%>
					</td>
					<td>
						<p class="required">0-100000<br>Note : "0" means "Unlimited"</p>
					</td>
				</tr>			
			</table>
		</fieldset>
		
		<fieldset class="">
		<legend>Monitor Settings</legend>
			<p class="caution">	<img src="images/exclamation3.gif" alt="Caution!!" width="16" height="14" align="middle">	
			 Disable Area when you push "Apply" button.</p>
			<table class="status">
			<tr>
				<th>
					<label for="timeout">Check Timeout</label>
				</th>
				<td>
					<%
					{
						String invalidMessage = null;
						if ( null != errMessage ) {
							invalidMessage = errMessage.get("timeout");
						}
						if ( (vs == null) || (0 == vs.timeout) ){ 
							if ( dd.autoreload == true ) {
								out.println("<input type=\"text\" id=\"timeout\" value=\"\" name=\"timeout\" maxlength=\"10\" />");
							}
							else {
								out.println("<input class=\"read\" readonly type=\"text\" id=\"timeout\" value=\"\" name=\"timeout\" maxlength=\"10\" />");
							}
						}
						else {
							if ( dd.autoreload == true ) {
								out.println("<input type=\"text\" id=\"timeout\" value=\"" + vs.timeout + "\" name=\"timeout\" maxlength=\"10\" />");
							}
							else {
								out.println("<input class=\"read\" readonly type=\"text\" id=\"timeout\" value=\"\" name=\"timeout\" maxlength=\"10\" />");
							}
						}
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">1-2147483647(sec)</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="check_type">Check Type</label>
				</th>
				<td>
				<% 
				if ( dd.autoreload == true ) {
				%>
					<input type="text" id="check_type" value="<%
					 if ( null != vs ) 
							out.println(vs.checktype); %>" name="check_type" maxlength="9" />											
				<% 
				}
				else{
				%>
					<input class="read" readonly type="text" id="check_type" value="<%
					 if ( null != vs ) 
							out.println(vs.checktype); %>" name="check_type" maxlength="9" />
					<% 
					}
					if ( null != errMessage ) {
						String invalidMessage = errMessage.get("check_type");
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>					
				</td>
				<td>
					<p class="required">Any Of The Following<br>negotiate, connect, ping, off, on, 0-9</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="check_service">Check Service</label>
				</th>
				<td>
					<% if ( dd.autoreload == true ) {%>
					<select id="check_service" name="check_service">
						<option value=""<%
						if ( ( null != vs ) && (vs.service.equals("")) )
							out.print(" selected");
						%>></option>
						<option value="ftp"<%
						if ( ( null != vs ) && (vs.service.equals("ftp")) )
							out.print(" selected");
						%>>FTP</option>
						<option value="smtp"<%
						if ( ( null != vs ) && (vs.service.equals("smtp")) )
							out.print(" selected");
						%>>SMTP</option>
						<option value="dns"<%
						if ( ( null != vs ) && (vs.service.equals("dns")))
							out.print(" selected");
						%>>DNS</option>
						<option value="http"<%
						if ( ( null != vs ) && (vs.service.equals("http")) )
							out.print(" selected");
						%>>HTTP</option>
						<option value="pop"<%
						if ( ( null != vs ) && (vs.service.equals("pop")) )
							out.print(" selected");
						%>>POP</option>
						<option value="nntp"<%
						if ( ( null != vs ) && (vs.service.equals("nntp")) )
							out.print(" selected");
						%>>NNTP</option>
						<option value="imap"<%
						if ( ( null != vs ) && (vs.service.equals("imap")) )
							out.print(" selected");
						%>>IMAP</option>
						<option value="ldap"<%
						if ( ( null != vs ) && (vs.service.equals("ldap")) )
							out.print(" selected");
						%>>LDAP</option>
						<option value="https"<%
						if ( ( null != vs ) && (vs.service.equals("https")) )
							out.print(" selected");
						%>>HTTPS</option>
						<option value="mysql"<%
						if ( ( null != vs ) && (vs.service.equals("mysql")) )
							out.print(" selected");
						%>>MySQL</option>
						<option value="pgsql"<%
						if ( ( null != vs ) && (vs.service.equals("pgsql")) )
							out.print(" selected");
						%>>PostgreSQL</option>
						<option value="sip"<%
						if ( ( null != vs ) && (vs.service.equals("sip")) )
							out.print(" selected");
						%>>SIP</option>
						<option value="none"<%
						if ( ( null != vs ) && (vs.service.equals("none")) )
							out.print(" selected");
						%>>None</option>
					</select>
					<%}
					else
					{
					%>
					<select class="read" disabled id="check_service" name="check_service">
						<option value=""<%
						if ( ( null != vs ) && (vs.service.equals("")) )
							out.print(" selected");
						%>></option>
						<option value="ftp"<%
						if ( ( null != vs ) && (vs.service.equals("ftp")) )
							out.print(" selected");
						%>>FTP</option>
						<option value="smtp"<%
						if ( ( null != vs ) && (vs.service.equals("smtp")) )
							out.print(" selected");
						%>>SMTP</option>
						<option value="dns"<%
						if ( ( null != vs ) && (vs.service.equals("dns")))
							out.print(" selected");
						%>>DNS</option>
						<option value="http"<%
						if ( ( null != vs ) && (vs.service.equals("http")) )
							out.print(" selected");
						%>>HTTP</option>
						<option value="pop"<%
						if ( ( null != vs ) && (vs.service.equals("pop")) )
							out.print(" selected");
						%>>POP</option>
						<option value="nntp"<%
						if ( ( null != vs ) && (vs.service.equals("nntp")) )
							out.print(" selected");
						%>>NNTP</option>
						<option value="imap"<%
						if ( ( null != vs ) && (vs.service.equals("imap")) )
							out.print(" selected");
						%>>IMAP</option>
						<option value="ldap"<%
						if ( ( null != vs ) && (vs.service.equals("ldap")) )
							out.print(" selected");
						%>>LDAP</option>
						<option value="https"<%
						if ( ( null != vs ) && (vs.service.equals("https")) )
							out.print(" selected");
						%>>HTTPS</option>
						<option value="mysql"<%
						if ( ( null != vs ) && (vs.service.equals("mysql")) )
							out.print(" selected");
						%>>MySQL</option>
						<option value="pgsql"<%
						if ( ( null != vs ) && (vs.service.equals("pgsql")) )
							out.print(" selected");
						%>>PostgreSQL</option>
						<option value="sip"<%
						if ( ( null != vs ) && (vs.service.equals("sip")) )
							out.print(" selected");
						%>>SIP</option>
						<option value="none"<%
						if ( ( null != vs ) && (vs.service.equals("none")) )
							out.print(" selected");
						%>>None</option>
					</select>
					<%
					}
						if ( null != errMessage ) {
							String invalidMessage = errMessage.get("check_service");
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
					%>
				</td>
				<td>
					<p class="required"></p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="quiescent">Quiescent</label>
				</th>
				<td>
					<%if (dd.autoreload == true) { %>
					<select id="quiescent" name="quiescent">
						<option value=""<%
						if ( ( null != vs ) && (vs.quiescent.equals("")) )
							out.print(" selected");
						%>></option>
						<option value="yes"<%
						if ( ( null != vs ) && (vs.quiescent.equals("yes")) )
							out.print(" selected");
						%>>Yes</option>
						<option value="no"<%
						if ( ( null != vs ) && (vs.quiescent.equals("no")) )
							out.print(" selected");
						%>>No</option>
					</select>
					<%
					}
					else
					{
					%>
					<select class="read" disabled id="quiescent" name="quiescent">
						<option value=""<%
						if ( ( null != vs ) && (vs.quiescent.equals("")) )
							out.print(" selected");
						%>></option>
						<option value="yes"<%
						if ( ( null != vs ) && (vs.quiescent.equals("yes")) )
							out.print(" selected");
						%>>Yes</option>
						<option value="no"<%
						if ( ( null != vs ) && (vs.quiescent.equals("no")) )
							out.print(" selected");
						%>>No</option>
					</select>
					
					<%
					}
						if ( null != errMessage ) {
							String invalidMessage = errMessage.get("quiescent");
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
					%>
				</td>
				<td>
					<p class="required">Default : No</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="down_callback">Real Server Down Callback</label>
				</th>
				<td>
					<% 
					if ( dd.autoreload == true ) {
					%>	
						<input type="text" id="down_callback" value="<%
						 if ( null != vs ) 
								out.println(vs.downcallback); %>" name="down_callback" maxlength=\"127\" />											
					<% 
					}
					else{
					%>
						<input class="read" readonly type="text" id="down_callback" value="<%
						 if ( null != vs ) 
								out.println(vs.downcallback); %>" name="down_callback" maxlength=\"127\" />	
					<% 
					}
					if ( null != errMessage ) {
						String invalidMessage = errMessage.get("down_callback");
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">Up to 127 one-byte characters in English<br>Be effctive only if CheckService : HTTP, HTTPS, LDAP, MySQL, PostgreSQL, SIP, None</p>
				</td>			
			</tr>					
			<tr>
				<th>
					<label for="up_callback">Real Server Up Callback</label>
				</th>
				<td>
					<% 
					if ( dd.autoreload == true ) {
					%>	
						<input type="text" id="up_callback" value="<% 
						if ( null != vs ) 
								out.println(vs.upcallback); %>" name="up_callback" maxlength=\"127\" />
					<% 
					}
					else{
					%>
						<input class="read" readonly type="text" id="up_callback" value="<%
						 if ( null != vs ) 
								out.println(vs.upcallback); %>" name="up_callback" maxlength=\"127\" />
					<% 
					}
					if ( null != errMessage ) {
						String invalidMessage = errMessage.get("up_callback");
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">Up to 127 one-byte characters in English</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="check_port">Check Port</label>
				</th>
				<td>
					<%
					{
					String invalidMessage = null;
					if ( null != errMessage ){
						invalidMessage = errMessage.get("check_port");
					}
					if ( (vs == null) || (0 == vs.checkport) ){
						if ( dd.autoreload == true ) {
						out.println("<input type=\"text\" id=\"check_port\" value=\"\" name=\"check_port\" maxlength=\"5\" />");
						}
						else{
							out.println("<input class=\"read\" readonly type=\"text\" id=\"check_port\" value=\"\" name=\"check_port\" maxlength=\"5\" />");
						}
					}
					else{
						if ( dd.autoreload == true ) {
							out.println("<input type=\"text\" id=\"check_port\" value=\"" + vs.checkport + "\" name=\"check_port\" maxlength=\"5\" />");
						}
						else{
							out.println("<input class=\"read\" readonly type=\"text\" id=\"check_port\" value=\"" +  vs.checkport + "\" name=\"check_port\" maxlength=\"5\" />");
						}
					}
					if ( null != invalidMessage ) {
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
					}
					}
					%>
				</td>
				<td>
					<p class="required">1-65535</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="request">Request Path</label>
				</th>
				<td>
					<% 
					if ( dd.autoreload == true ) {
					%>					
						<input type="text" id="request" value="<% 
							if ( null != vs ) 
							out.println(vs.request); %>" name="request" maxlength=\"127\" />
					<% 
					}
					else{						
					 %>
					 	<input class="read" readonly type="text" id="request" value="<% 
							if ( null != vs ) 
							out.println(vs.request); %>" name="request" maxlength=\"127\" />
					<%
					}
					if ( null != errMessage ) {
						String invalidMessage = errMessage.get("request");
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">Up to 127 one-byte characters in English<br>Be effctive only if CheckService : HTTP, HTTPS, LDAP, MySQL, PostgreSQL, SIP, None</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="receive">Receive String</label>
				</th>
				<td>
					<% 
					if ( dd.autoreload == true ) {
					%>					
						<input type="text" id="receive" value="<%
						 	if ( null != vs ) 
							out.println(vs.receive); %>" name="receive" maxlength=\"127\" />
					<% 
					}
					else {
					 %>
					 	<input class="read" readonly type="text" id="receive" value="<%
						 	if ( null != vs ) 
							out.println(vs.receive); %>" name="receive" maxlength=\"127\" />			
	
					<%
					}
						if ( null != errMessage ) {
							String invalidMessage = errMessage.get("receive");
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
					%>
				</td>
				<td>
					<p class="required">Up to 127 one-byte characters in English<br>Be effctive only if CheckService : HTTP, HTTPS, LDAP, FTP, DNS</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="method">HTTP Method</label>
				</th>
				<td>
					<% if ( dd.autoreload == true ){
					%>			
					<select id="method" name="method">
						<option value=""<%
						if ( ( vs != null ) && (vs.httpmethod.equals("")) )
							out.print(" selected");
						%>></option>
						<option value="GET"<%
						if ( ( vs != null ) && (vs.httpmethod.equals("GET")) )
							out.print(" selected");
						%>>GET</option>
						<option value="HEAD"<%
						if ( ( vs != null ) && (vs.httpmethod.equals("HEAD")) )
							out.print(" selected");
						%>>HEAD</option>
					</select>
					<%
					}
					else
					{
					%>
					<select class="read" disabled id="method" name="method">
						<option value=""<%
						if ( ( vs != null ) && (vs.httpmethod.equals("")) )
							out.print(" selected");
						%>></option>
						<option value="GET"<%
						if ( ( vs != null ) && (vs.httpmethod.equals("GET")) )
							out.print(" selected");
						%>>GET</option>
						<option value="HEAD"<%
						if ( ( vs != null ) && (vs.httpmethod.equals("HEAD")) )
							out.print(" selected");
						%>>HEAD</option>
					</select>
					
					<%
					}
						if ( null != errMessage ) {
							String invalidMessage = errMessage.get("method");
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
					%>
				</td>
				<td>
					<p class="required">Be effctive only if CheckService : HTTP, HTTPS</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="virtual_host">Virtual Host</label>
				</th>
				<td>
					<% 
					if ( dd.autoreload == true ) {
					%>									
						<input type="text" id="virtual_host" value="<%
						 	if ( null != vs ) 
								out.println(vs.virtualhost); %>" name="virtual_host" maxlength=\"127\" />
					<% 
					}
					else{						
					 %>
						<input class="read" readonly type="text" id="virtual_host" value="<% 
							if ( null != vs ) 
								out.println(vs.virtualhost); %>" name="virtual_host" maxlength=\"127\" />
					<% 
					}
					if ( null != errMessage ) {
						String invalidMessage = errMessage.get("virtual_host");
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">Up to 127 one-byte characters in English<br>Be effctive only if CheckService : HTTP, HTTPS</p>
				</td>
			</tr>
			
			<tr>
				<th>
					<label for="login_user">Login Username</label>
				</th>
				<td>
					<% 
					if ( dd.autoreload == true ) {
					%>									
						<input type="text" id="login_user" value="<% 
							if ( null != vs ) 
								out.println(vs.login); %>" name="login_user" maxlength=\"32\" />
					<% 
					}
					else{						
					 %>
					 	<input class="read" readonly type="text" id="login_user" value="<%
						 	if ( null != vs ) 
								out.println(vs.login); %>" name="login_user" maxlength=\"32\" />
					<% 
					}
					if ( null != errMessage ) {
						String invalidMessage = errMessage.get("login_user");
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">Up to 32 one-byte characters in English<br>Followings : Effctive only when CheckService is FTP, POP, IMAP, MySQL, PostgreSQL, and SIP</p>
				</td>
			</tr>
			
			
			
			<tr>
				<th>
					<label for="login_pass">Login Password</label>
				</th>
				<td>
					<% 
					if ( dd.autoreload == true ) {
					%>									
						<input type="text" id="login_pass" value="<% 
							if ( null != vs ) 
								out.println(vs.passwd); %>" name="login_pass" maxlength=\"32\" />
					<% 
					}
					else{						
					 %>
					 	<input class="read" readonly type="text" id="login_pass" value="<%
						 	if ( null != vs ) 
								out.println(vs.passwd); %>" name="login_pass" maxlength=\"32\" />
					<% 
					}
					if ( null != errMessage ) {
						String invalidMessage = errMessage.get("login_pass");
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">Up to 32 one-byte characters in English<br>Be effctive only if CheckService : FTP, POP, IMAP, MySQL, PostgreSQL, SIP</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="db">Database Name</label>
				</th>
				<td>
					<% 
					if ( dd.autoreload == true ) {
					%>													
					<input type="text" id="db" value="<%
					 	if ( null != vs ) 
						out.println(vs.passwd); %>" name="db" maxlength=\"32\" />
					<% 
					}
					else{						
					 %>
					<input class="read" readonly type="text" id="db" value="<% 
						if ( null != vs ) 
						out.println(vs.passwd); %>" name="db" maxlength=\"32\" />
					<%
					}
					if ( null != errMessage ) {
						String invalidMessage = errMessage.get("db");
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">Up to 32 one-byte characters in English<br>Be effctive only if CheckService : MySQL, PostgreSQL</p>
				</td>
			</tr>
			</table>
			</fieldset>
	
			<h2> RealServer Info</h2>
			<%
			if ( (vs != null) && (vs.real != null) && (vs.real.size() != 0 )) {
			%>
			<fieldset class="">
			<legend>Real Servers</legend>
			<%
					for (int i = 0; i < vs.real.size(); i++) {
						int ripNum = i + 1;
						EndPoint rip = (EndPoint) vs.real.elementAt(i);
			%>
			<table class="status">
			<tr>
				<td rowspan="3" class="check">
					<input type="checkbox" name="rs<%= ripNum %>_remove" />
				</td>
				<th class="check">
					<label for="rs<%= ripNum %>_ip">IP Address</label>
				</th>
				<td>
					<input type="text" id="rs<%= ripNum %>_ip" value="<%= rip.host %>" name="rs<%= ripNum %>_ip" maxlength="15" />
					<%
						if ( null != errMessage ) {
							String invalidMessage = errMessage.get("rs" + ripNum + "_ip");
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
					%>
				</td>
				<td>
					<p class="required">[0-255].[0-255].[0-255].[0-255]</p>
				</td>
			</tr>
			<tr>
				<th class="check">
					<label for="rs<%= ripNum %>_port">Port Number</label>
				</th>
				<td>
					<%
					{
						String invalidMessage = null;
						if ( null != errMessage ) {
							invalidMessage = errMessage.get("rs" + ripNum + "_port");
						}
						if (null == rip.port){
							out.print("<input type=\"text\" id=\"rs\" + ripNum + \"_port\" value=\"\" name=\"rs" + ripNum + "_port\" />");
						}
						else {
							out.print("<input type=\"text\" id=\"rs\" + ripNum + \"_port\" value=\"" + rip.port + "\" name=\"rs" + ripNum + "_port\" />");
						}
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">1-65535, service name</p>
				</td>
			</tr>
			<tr>
				<th class="check">
					<label for="rs<%= ripNum %>_weight">Weight</label>
				</th>
				<td>
					<%
					{
						String invalidMessage = null;
						if ( null != errMessage ) {
							invalidMessage = errMessage.get("rs" + ripNum + "_weight");
						}
						if ( ( null != invalidMessage ) && ( 1 == rip.weight ) ){
							out.print("<input type=\"text\" id=\"rs\"" + ripNum + "\"_weight\" value=\"\" name=\"rs" + ripNum + "_weight\" maxlength=\"3\" />");
						}
						else {
							out.print("<input type=\"text\" id=\"rs\"" + ripNum + "\"_weight\" value=\"" + rip.weight + "\" name=\"rs" + ripNum + "_weight\" maxlength=\"3\" />");
						}
						if( null != invalidMessage ){
							out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
						}
					}
					%>
				</td>
				<td>
					<p class="required">0-100<br>Default:1</p>
				</td>
			</tr>
			</table>
			<%	
				}
			%>
			<input name="<%= ButtonMode.REMOVE %>" type="submit" value=" >> Remove RealServers" />
			</fieldset>
			<%
			}
			 %>
				
	
			<fieldset class="">
			<legend>New Real Server</legend>
			<table class="status">
				<tr>
					<th>
						<label for="new_ip">IP Address</label>
					</th>
					<td>
						<input type="text" id="new_ip" value="" name="new_ip" maxlength="15" />
					</td>
					<td>
						<p class="required">[0-255].[0-255].[0-255].[0-255]</p>
					</td>
				</tr>
				<tr>
					<th>
						<label for="new_port">Port Number</label>
					</th>
					<td>
						<input type="text" id="new_port" value="" name="new_port" />
					</td>
					<td>
						<p class="required">1-65535, service name</p>
					</td>
				</tr>
				<tr>
					<th>
						<label for="new_weight">Weight</label>
					</th>
					<td>
						<input type="text" id="new_weight" value="" name="new_weight" maxlength="3" />
					</td>
					<td>
						<p class="required">0-100</p>
					</td>
				</tr>
			</table>
			<input name="<%= ButtonMode.ADD %>" type="submit" value=" >> Add a RealServer" />
			</fieldset>
	
			<h2> SorryServer Info</h2>
			<fieldset class="">
			<legend>Sorry Settings</legend>
			<table class="status">
			<tr>
				<th>
					<label for="sorry_ip">IP Address</label>
				</th>
				<td>
					<input type="text" id="sorry_ip" value="<%
					 if ( null != vs ) 
							out.println(vs.sorryserver.host); %>" name="sorry_ip" maxlength="15" />
					<% 
						if ( null != errMessage ) {
							String invalidMessage = errMessage.get("sorry_ip");
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
					%>
				</td>
				<td>
					<p class="required">[0-255].[0-255].[0-255].[0-255]</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="sorry_port">Port Number</label>
				</th>
				<td>
	
				<%
				{
					String invalidMessage = null;
					if ( null != errMessage ) {
						invalidMessage = errMessage.get("sorry_port");
					}

					if ( (vs == null) || (null == vs.sorryserver.port) ){

						out.println("<input type=\"text\" id=\"sorry_port\" value=\"\" name=\"sorry_port\" />");
					}											
					else{
						out.println("<input type=\"text\" id=\"sorry_port\" value=\"" + vs.sorryserver.port + "\"name=\"sorry_port\" />");
					}																
					if( null != invalidMessage ){
						out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
					}
				}
				%>
				</td>
				<td>
					<p class="required">1-65535, service name</p>
				</td>
			</tr>
			<tr>
				<th>
					<label for="sorry">Sorry Flag</label>
				</th>
				<td>
					<select id="sorry" name="sorry_flag">
						<option value=""></option>
						<option value="on"<%
						if ( (vs != null ) && (vs.sorryflag) )
							out.print(" selected");
						%>>On</option>
						<option value="off"<%
						if (  (vs != null ) && !(vs.sorryflag) )
							out.print(" selected");
						%>>Off</option>
					</select>
					<% 
						if ( null != errMessage ) {
							String invalidMessage = errMessage.get("sorry_flag");
							if( null != invalidMessage ){
								out.println("<p class=\"invalid\">" + invalidMessage + "</p>");
							}
						}
					%>
				</td>
				<td>
					<p class="required">Default : Off</p>
				</td>
			</tr>
			</table>
			</fieldset>
		
		<input type="submit" name="button" value="<%=ButtonMode.APPLY %>" onClick="return confirm(add_vs_apply)" />
		<%
			if (dd.autoreload == true) {
		%>
		<input type="submit" name="button" value="<%= ButtonMode.SAVE %>" onClick="return confirm(add_vs_save)" />
		<%
				if (cd.self_status == ClusterStatus.ACTIVE || cd.self_status == ClusterStatus.STANDBY) {
		%>
		<input type="submit" name="button" value="<%= ButtonMode.SAVESYNC %>" onClick="return confirm(add_vs_savesync)" />
		<%
				}
			}
		%>
		</form>
	</div>
<%
}
else{
	response.sendRedirect(RedirectPages.TOPMENU);
	return;
}
%>	

	
	</body>
</html>